/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.expression.proto;

import com.google.protobuf.GeneratedMessageV3;
import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionVisitor;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.FunctionOption;
import io.substrait.expression.WindowBound;
import io.substrait.extension.ExtensionCollector;
import io.substrait.extension.SimpleExtension;
import io.substrait.proto.Expression;
import io.substrait.proto.FunctionArgument;
import io.substrait.proto.Rel;
import io.substrait.proto.SortField;
import io.substrait.proto.Type;
import io.substrait.relation.RelProtoConverter;
import io.substrait.type.proto.TypeProtoConverter;
import io.substrait.util.EmptyVisitationContext;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ExpressionProtoConverter
implements ExpressionVisitor<io.substrait.proto.Expression, EmptyVisitationContext, RuntimeException> {
    protected final RelProtoConverter relProtoConverter;
    protected final TypeProtoConverter typeProtoConverter;
    protected final ExtensionCollector extensionCollector;

    public ExpressionProtoConverter(ExtensionCollector extensionCollector, RelProtoConverter relProtoConverter) {
        this.extensionCollector = extensionCollector;
        this.relProtoConverter = relProtoConverter;
        this.typeProtoConverter = new TypeProtoConverter(extensionCollector);
    }

    public RelProtoConverter getRelProtoConverter() {
        return this.relProtoConverter;
    }

    public TypeProtoConverter getTypeProtoConverter() {
        return this.typeProtoConverter;
    }

    public io.substrait.proto.Expression toProto(Expression expression) {
        return expression.accept(this, EmptyVisitationContext.INSTANCE);
    }

    public List<io.substrait.proto.Expression> toProto(List<Expression> expressions) {
        return expressions.stream().map(this::toProto).collect(Collectors.toList());
    }

    protected Rel toProto(io.substrait.relation.Rel rel) {
        return this.relProtoConverter.toProto(rel);
    }

    protected Type toProto(io.substrait.type.Type type) {
        return this.typeProtoConverter.toProto(type);
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.NullLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNull(this.toProto(expr.type())));
    }

    private io.substrait.proto.Expression lit(Consumer<Expression.Literal.Builder> consumer) {
        Expression.Literal.Builder builder = Expression.Literal.newBuilder();
        consumer.accept(builder);
        return io.substrait.proto.Expression.newBuilder().setLiteral(builder).build();
    }

    private io.substrait.proto.Expression nested(Consumer<Expression.Nested.Builder> consumer) {
        Expression.Nested.Builder builder = Expression.Nested.newBuilder();
        consumer.accept(builder);
        return io.substrait.proto.Expression.newBuilder().setNested(builder).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.BoolLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setBoolean(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.I8Literal expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setI8(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.I16Literal expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setI16(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.I32Literal expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setI32(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.I64Literal expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setI64(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.FP32Literal expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setFp32(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.FP64Literal expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setFp64(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.StrLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setString(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.BinaryLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setBinary(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.TimeLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setTime(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.DateLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setDate(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.TimestampLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setTimestamp(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.TimestampTZLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setTimestampTz(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.PrecisionTimestampLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setPrecisionTimestamp(Expression.Literal.PrecisionTimestamp.newBuilder().setValue(expr.value()).setPrecision(expr.precision()).build()).build());
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.PrecisionTimestampTZLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setPrecisionTimestampTz(Expression.Literal.PrecisionTimestamp.newBuilder().setValue(expr.value()).setPrecision(expr.precision()).build()).build());
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.IntervalYearLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setIntervalYearToMonth(Expression.Literal.IntervalYearToMonth.newBuilder().setYears(expr.years()).setMonths(expr.months())));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.IntervalDayLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setIntervalDayToSecond(Expression.Literal.IntervalDayToSecond.newBuilder().setDays(expr.days()).setSeconds(expr.seconds()).setSubseconds(expr.subseconds()).setPrecision(expr.precision())));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.IntervalCompoundLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setIntervalCompound(Expression.Literal.IntervalCompound.newBuilder().setIntervalYearToMonth(Expression.Literal.IntervalYearToMonth.newBuilder().setYears(expr.years()).setMonths(expr.months())).setIntervalDayToSecond(Expression.Literal.IntervalDayToSecond.newBuilder().setDays(expr.days()).setSeconds(expr.seconds()).setSubseconds(expr.subseconds()).setPrecision(expr.precision()))));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.UUIDLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setUuid(expr.toBytes()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.FixedCharLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setFixedChar(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.VarCharLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setVarChar(Expression.Literal.VarChar.newBuilder().setValue(expr.value()).setLength(expr.length())));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.FixedBinaryLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setFixedBinary(expr.value()));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.DecimalLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> bldr.setNullable(expr.nullable()).setDecimal(Expression.Literal.Decimal.newBuilder().setValue(expr.value()).setPrecision(expr.precision()).setScale(expr.scale())));
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.MapLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> {
            List keyValues = expr.values().entrySet().stream().map(e -> {
                Expression.Literal key = this.toLiteral((Expression)e.getKey());
                Expression.Literal value = this.toLiteral((Expression)e.getValue());
                return Expression.Literal.Map.KeyValue.newBuilder().setKey(key).setValue(value).build();
            }).collect(Collectors.toList());
            bldr.setNullable(expr.nullable()).setMap(Expression.Literal.Map.newBuilder().addAllKeyValues(keyValues));
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.EmptyMapLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> {
            Type protoMapType = this.toProto(expr.getType());
            bldr.setEmptyMap(protoMapType.getMap()).setNullable(expr.nullable());
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.ListLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> {
            List values = expr.values().stream().map(this::toLiteral).collect(Collectors.toList());
            bldr.setNullable(expr.nullable()).setList(Expression.Literal.List.newBuilder().addAllValues(values));
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.EmptyListLiteral expr, EmptyVisitationContext context) throws RuntimeException {
        return this.lit(builder -> {
            Type protoListType = this.toProto(expr.getType());
            builder.setEmptyList(protoListType.getList()).setNullable(expr.nullable());
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.StructLiteral expr, EmptyVisitationContext context) {
        return this.lit(bldr -> {
            List values = expr.fields().stream().map(this::toLiteral).collect(Collectors.toList());
            bldr.setNullable(expr.nullable()).setStruct(Expression.Literal.Struct.newBuilder().addAllFields(values));
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.NestedStruct expr, EmptyVisitationContext context) {
        return this.nested(bldr -> {
            List values = expr.fields().stream().map(this::toProto).collect(Collectors.toList());
            bldr.setStruct(Expression.Nested.Struct.newBuilder().addAllFields(values)).setNullable(expr.nullable());
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.UserDefinedAnyLiteral expr, EmptyVisitationContext context) {
        int typeReference = this.extensionCollector.getTypeReference(SimpleExtension.TypeAnchor.of(expr.urn(), expr.name()));
        return this.lit(bldr -> {
            Expression.Literal.UserDefined.Builder userDefinedBuilder = Expression.Literal.UserDefined.newBuilder().setTypeReference(typeReference).addAllTypeParameters(expr.typeParameters().stream().map(this.typeProtoConverter::toProto).collect(Collectors.toList())).setValue(expr.value());
            bldr.setNullable(expr.nullable()).setUserDefined(userDefinedBuilder).build();
        });
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.UserDefinedStructLiteral expr, EmptyVisitationContext context) {
        int typeReference = this.extensionCollector.getTypeReference(SimpleExtension.TypeAnchor.of(expr.urn(), expr.name()));
        return this.lit(bldr -> {
            Expression.Literal.Struct structLiteral = Expression.Literal.Struct.newBuilder().addAllFields(expr.fields().stream().map(this::toLiteral).collect(Collectors.toList())).build();
            Expression.Literal.UserDefined.Builder userDefinedBuilder = Expression.Literal.UserDefined.newBuilder().setTypeReference(typeReference).addAllTypeParameters(expr.typeParameters().stream().map(this.typeProtoConverter::toProto).collect(Collectors.toList())).setStruct(structLiteral);
            bldr.setNullable(expr.nullable()).setUserDefined(userDefinedBuilder).build();
        });
    }

    private Expression.Literal toLiteral(Expression expression) {
        io.substrait.proto.Expression e = this.toProto(expression);
        assert (e.getRexTypeCase() == Expression.RexTypeCase.LITERAL);
        return e.getLiteral();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.Switch expr, EmptyVisitationContext context) {
        List clauses = expr.switchClauses().stream().map(s -> Expression.SwitchExpression.IfValue.newBuilder().setIf(this.toLiteral(s.condition())).setThen(this.toProto(s.then())).build()).collect(Collectors.toList());
        return io.substrait.proto.Expression.newBuilder().setSwitchExpression(Expression.SwitchExpression.newBuilder().setMatch(this.toProto(expr.match())).addAllIfs(clauses).setElse(this.toProto(expr.defaultClause()))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.IfThen expr, EmptyVisitationContext context) {
        List clauses = expr.ifClauses().stream().map(s -> Expression.IfThen.IfClause.newBuilder().setIf(this.toProto(s.condition())).setThen(this.toProto(s.then())).build()).collect(Collectors.toList());
        return io.substrait.proto.Expression.newBuilder().setIfThen(Expression.IfThen.newBuilder().addAllIfs(clauses).setElse(this.toProto(expr.elseClause()))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.ScalarFunctionInvocation expr, EmptyVisitationContext context) {
        FunctionArg.FuncArgVisitor<FunctionArgument, EmptyVisitationContext, RuntimeException> argVisitor = FunctionArg.toProto(this.typeProtoConverter, this);
        return io.substrait.proto.Expression.newBuilder().setScalarFunction(Expression.ScalarFunction.newBuilder().setOutputType(this.toProto(expr.getType())).setFunctionReference(this.extensionCollector.getFunctionReference(expr.declaration())).addAllArguments(expr.arguments().stream().map(a -> (FunctionArgument)a.accept(expr.declaration(), 0, argVisitor, context)).collect(Collectors.toList())).addAllOptions(expr.options().stream().map(ExpressionProtoConverter::from).collect(Collectors.toList()))).build();
    }

    public static io.substrait.proto.FunctionOption from(FunctionOption option) {
        return io.substrait.proto.FunctionOption.newBuilder().setName(option.getName()).addAllPreference(option.values()).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.Cast expr, EmptyVisitationContext context) {
        return io.substrait.proto.Expression.newBuilder().setCast(Expression.Cast.newBuilder().setInput(this.toProto(expr.input())).setType(this.toProto(expr.getType())).setFailureBehavior(expr.failureBehavior().toProto())).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.SingleOrList expr, EmptyVisitationContext context) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setSingularOrList(Expression.SingularOrList.newBuilder().setValue(this.toProto(expr.condition())).addAllOptions(this.toProto(expr.options()))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.MultiOrList expr, EmptyVisitationContext context) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setMultiOrList(Expression.MultiOrList.newBuilder().addAllValue(this.toProto(expr.conditions())).addAllOptions(expr.optionCombinations().stream().map(r -> Expression.MultiOrList.Record.newBuilder().addAllFields(this.toProto(r.values())).build()).collect(Collectors.toList()))).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.NestedList expr, EmptyVisitationContext context) throws RuntimeException {
        List values = expr.values().stream().map(this::toProto).collect(Collectors.toList());
        return io.substrait.proto.Expression.newBuilder().setNested(Expression.Nested.newBuilder().setList(Expression.Nested.List.newBuilder().addAllValues(values)).setNullable(expr.nullable())).build();
    }

    @Override
    public io.substrait.proto.Expression visit(FieldReference expr, EmptyVisitationContext context) {
        Expression.ReferenceSegment seg = null;
        for (FieldReference.ReferenceSegment segment : expr.segments()) {
            Expression.ReferenceSegment.Builder protoSegment;
            GeneratedMessageV3.Builder bldr;
            FieldReference.ReferenceSegment f;
            if (segment instanceof FieldReference.StructField) {
                f = (FieldReference.StructField)segment;
                bldr = Expression.ReferenceSegment.StructField.newBuilder().setField(((FieldReference.StructField)f).offset());
                if (seg != null) {
                    bldr.setChild(seg);
                }
                protoSegment = Expression.ReferenceSegment.newBuilder().setStructField((Expression.ReferenceSegment.StructField.Builder)bldr);
            } else if (segment instanceof FieldReference.ListElement) {
                f = (FieldReference.ListElement)segment;
                bldr = Expression.ReferenceSegment.ListElement.newBuilder().setOffset(((FieldReference.ListElement)f).offset());
                if (seg != null) {
                    bldr.setChild(seg);
                }
                protoSegment = Expression.ReferenceSegment.newBuilder().setListElement((Expression.ReferenceSegment.ListElement.Builder)bldr);
            } else if (segment instanceof FieldReference.MapKey) {
                f = (FieldReference.MapKey)segment;
                bldr = Expression.ReferenceSegment.MapKey.newBuilder().setMapKey(this.toLiteral(((FieldReference.MapKey)f).key()));
                if (seg != null) {
                    bldr.setChild(seg);
                }
                protoSegment = Expression.ReferenceSegment.newBuilder().setMapKey((Expression.ReferenceSegment.MapKey.Builder)bldr);
            } else {
                throw new IllegalArgumentException("Unhandled type: " + segment);
            }
            seg = protoSegment.build();
        }
        Expression.FieldReference.Builder out = Expression.FieldReference.newBuilder().setDirectReference(seg);
        if (expr.inputExpression().isPresent()) {
            out.setExpression(this.toProto(expr.inputExpression().get()));
        } else if (expr.outerReferenceStepsOut().isPresent()) {
            out.setOuterReference(Expression.FieldReference.OuterReference.newBuilder().setStepsOut(expr.outerReferenceStepsOut().get()));
        } else {
            out.setRootReference(Expression.FieldReference.RootReference.getDefaultInstance());
        }
        return io.substrait.proto.Expression.newBuilder().setSelection(out).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.SetPredicate expr, EmptyVisitationContext context) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setSubquery(Expression.Subquery.newBuilder().setSetPredicate(Expression.Subquery.SetPredicate.newBuilder().setPredicateOp(expr.predicateOp().toProto()).setTuples(this.toProto(expr.tuples())).build()).build()).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.ScalarSubquery expr, EmptyVisitationContext context) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setSubquery(Expression.Subquery.newBuilder().setScalar(Expression.Subquery.Scalar.newBuilder().setInput(this.toProto(expr.input())).build()).build()).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.InPredicate expr, EmptyVisitationContext context) throws RuntimeException {
        return io.substrait.proto.Expression.newBuilder().setSubquery(Expression.Subquery.newBuilder().setInPredicate(Expression.Subquery.InPredicate.newBuilder().setHaystack(this.toProto(expr.haystack())).addAllNeedles(this.toProto(expr.needles())).build()).build()).build();
    }

    @Override
    public io.substrait.proto.Expression visit(Expression.WindowFunctionInvocation expr, EmptyVisitationContext context) throws RuntimeException {
        FunctionArg.FuncArgVisitor<FunctionArgument, EmptyVisitationContext, RuntimeException> argVisitor = FunctionArg.toProto(this.typeProtoConverter, this);
        List args = expr.arguments().stream().map(a -> (FunctionArgument)a.accept(expr.declaration(), 0, argVisitor, context)).collect(Collectors.toList());
        Type outputType = this.toProto(expr.getType());
        List<io.substrait.proto.Expression> partitionExprs = this.toProto(expr.partitionBy());
        List sortFields = expr.sort().stream().map(s -> SortField.newBuilder().setDirection(s.direction().toProto()).setExpr(this.toProto(s.expr())).build()).collect(Collectors.toList());
        Expression.WindowFunction.Bound lowerBound = BoundConverter.convert(expr.lowerBound());
        Expression.WindowFunction.Bound upperBound = BoundConverter.convert(expr.upperBound());
        return io.substrait.proto.Expression.newBuilder().setWindowFunction(Expression.WindowFunction.newBuilder().setFunctionReference(this.extensionCollector.getFunctionReference(expr.declaration())).addAllArguments(args).setOutputType(outputType).setPhase(expr.aggregationPhase().toProto()).setInvocation(expr.invocation().toProto()).addAllSorts(sortFields).addAllPartitions(partitionExprs).setBoundsType(expr.boundsType().toProto()).setLowerBound(lowerBound).setUpperBound(upperBound).addAllOptions(expr.options().stream().map(ExpressionProtoConverter::from).collect(Collectors.toList()))).build();
    }

    public static class BoundConverter
    implements WindowBound.WindowBoundVisitor<Expression.WindowFunction.Bound, RuntimeException> {
        private static final BoundConverter TO_BOUND_VISITOR = new BoundConverter();

        public static Expression.WindowFunction.Bound convert(WindowBound bound) {
            return bound.accept(TO_BOUND_VISITOR);
        }

        private BoundConverter() {
        }

        @Override
        public Expression.WindowFunction.Bound visit(WindowBound.Preceding preceding) {
            return Expression.WindowFunction.Bound.newBuilder().setPreceding(Expression.WindowFunction.Bound.Preceding.newBuilder().setOffset(preceding.offset())).build();
        }

        @Override
        public Expression.WindowFunction.Bound visit(WindowBound.Following following) {
            return Expression.WindowFunction.Bound.newBuilder().setFollowing(Expression.WindowFunction.Bound.Following.newBuilder().setOffset(following.offset())).build();
        }

        @Override
        public Expression.WindowFunction.Bound visit(WindowBound.CurrentRow currentRow) {
            return Expression.WindowFunction.Bound.newBuilder().setCurrentRow(Expression.WindowFunction.Bound.CurrentRow.getDefaultInstance()).build();
        }

        @Override
        public Expression.WindowFunction.Bound visit(WindowBound.Unbounded unbounded) {
            return Expression.WindowFunction.Bound.newBuilder().setUnbounded(Expression.WindowFunction.Bound.Unbounded.getDefaultInstance()).build();
        }
    }
}

