/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.extension;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.substrait.expression.Expression;
import io.substrait.extension.BidiMap;
import io.substrait.extension.ImmutableSimpleExtension;
import io.substrait.function.ParameterizedType;
import io.substrait.function.ToTypeString;
import io.substrait.function.TypeExpression;
import io.substrait.type.Deserializers;
import io.substrait.type.TypeExpressionEvaluator;
import io.substrait.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Enclosing
public class SimpleExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleExtension.class);
    public static final String URN_LOCATOR_KEY = "urn";
    private static final Predicate<String> URN_CHECKER = Pattern.compile("^extension:[^:]+:[^:]+$").asPredicate();
    private static Pattern READ_WHOLE_FILE = Pattern.compile("\\A");

    private static void validateUrn(String urn) {
        if (urn == null || urn.trim().isEmpty()) {
            throw new IllegalArgumentException("URN cannot be null or empty");
        }
        if (!URN_CHECKER.test(urn)) {
            throw new IllegalArgumentException("URN must follow format 'extension:<namespace>:<name>', got: " + urn);
        }
    }

    private static ObjectMapper objectMapper(String urn) {
        InjectableValues.Std iv = new InjectableValues.Std();
        iv.addValue(URN_LOCATOR_KEY, (Object)urn);
        return new ObjectMapper((JsonFactory)new YAMLFactory()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).registerModule((Module)new Jdk8Module()).registerModule((Module)Deserializers.MODULE).setInjectableValues((InjectableValues)iv);
    }

    private SimpleExtension() {
    }

    public static ExtensionCollection load(List<String> resourcePaths) {
        if (resourcePaths.isEmpty()) {
            throw new IllegalArgumentException("Require at least one resource path.");
        }
        List extensions = resourcePaths.stream().map(path -> {
            ExtensionCollection extensionCollection;
            block8: {
                InputStream stream = ExtensionCollection.class.getResourceAsStream((String)path);
                try {
                    extensionCollection = SimpleExtension.load(path, stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                stream.close();
            }
            return extensionCollection;
        }).collect(Collectors.toList());
        ExtensionCollection complete = (ExtensionCollection)extensions.get(0);
        for (int i = 1; i < extensions.size(); ++i) {
            complete = complete.merge((ExtensionCollection)extensions.get(i));
        }
        return complete;
    }

    public static ExtensionCollection load(String uri, String content) {
        try {
            if (uri == null || uri.isEmpty()) {
                throw new IllegalArgumentException("URI cannot be null or empty");
            }
            ObjectMapper basicYamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            JsonNode rootNode = basicYamlMapper.readTree(content);
            JsonNode urnNode = rootNode.get(URN_LOCATOR_KEY);
            if (urnNode == null) {
                throw new IllegalArgumentException("Extension YAML file must contain a 'urn' field");
            }
            String urn = urnNode.asText();
            SimpleExtension.validateUrn(urn);
            ExtensionSignatures docWithoutUri = (ExtensionSignatures)SimpleExtension.objectMapper(urn).readValue(content, ExtensionSignatures.class);
            ImmutableSimpleExtension.ExtensionSignatures doc = ImmutableSimpleExtension.ExtensionSignatures.builder().from(docWithoutUri).build();
            return SimpleExtension.buildExtensionCollection(uri, doc);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ExtensionCollection load(String uri, InputStream stream) {
        try (Scanner scanner = new Scanner(stream);){
            scanner.useDelimiter(READ_WHOLE_FILE);
            String content = scanner.next();
            ExtensionCollection extensionCollection = SimpleExtension.load(uri, content);
            return extensionCollection;
        }
    }

    public static ExtensionCollection buildExtensionCollection(String uri, ExtensionSignatures extensionSignatures) {
        String urn = extensionSignatures.urn();
        SimpleExtension.validateUrn(urn);
        if (uri == null || uri == "") {
            throw new IllegalArgumentException("URI cannot be null or empty");
        }
        List scalarFunctionVariants = extensionSignatures.scalars().stream().flatMap(t -> t.resolve(urn)).collect(Collectors.toList());
        List aggregateFunctionVariants = extensionSignatures.aggregates().stream().flatMap(t -> t.resolve(urn)).collect(Collectors.toList());
        Stream windowFunctionVariants = extensionSignatures.windows().stream().flatMap(t -> t.resolve(urn));
        Stream<WindowFunctionVariant> windowAggFunctionVariants = aggregateFunctionVariants.stream().map(afi -> WindowFunctionVariant.builder().from((Function)afi).decomposability(afi.decomposability()).intermediate(afi.intermediate()).windowType(WindowType.STREAMING).build());
        List allWindowFunctionVariants = Stream.concat(windowFunctionVariants, windowAggFunctionVariants).collect(Collectors.toList());
        BidiMap<String, String> uriUrnMap = new BidiMap<String, String>();
        uriUrnMap.put(uri, urn);
        ImmutableSimpleExtension.ExtensionCollection collection = ImmutableSimpleExtension.ExtensionCollection.builder().scalarFunctions(scalarFunctionVariants).aggregateFunctions(aggregateFunctionVariants).windowFunctions(allWindowFunctionVariants).addAllTypes(extensionSignatures.types()).uriUrnMap(uriUrnMap).build();
        LOGGER.atDebug().log("Loaded {} aggregate functions and {} scalar functions from {}.", new Object[]{collection.aggregateFunctions().size(), collection.scalarFunctions().size(), extensionSignatures.urn()});
        return collection;
    }

    @Value.Immutable
    public static abstract class ExtensionCollection {
        private final Supplier<Set<String>> urnSupplier = Util.memoize(() -> Stream.concat(Stream.concat(this.scalarFunctions().stream().map(Function::urn), this.aggregateFunctions().stream().map(Function::urn)), this.windowFunctions().stream().map(Function::urn)).collect(Collectors.toSet()));
        private final Supplier<Map<TypeAnchor, Type>> typeLookup = Util.memoize(() -> this.types().stream().collect(Collectors.toMap(Type::getAnchor, java.util.function.Function.identity())));
        private final Supplier<Map<FunctionAnchor, ScalarFunctionVariant>> scalarFunctionsLookup = Util.memoize(() -> this.scalarFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));
        private final Supplier<Map<FunctionAnchor, AggregateFunctionVariant>> aggregateFunctionsLookup = Util.memoize(() -> this.aggregateFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));
        private final Supplier<Map<FunctionAnchor, WindowFunctionVariant>> windowFunctionsLookup = Util.memoize(() -> this.windowFunctions().stream().collect(Collectors.toMap(Function::getAnchor, java.util.function.Function.identity())));

        @Value.Default
        BidiMap<String, String> uriUrnMap() {
            return new BidiMap<String, String>();
        }

        public abstract List<Type> types();

        public abstract List<ScalarFunctionVariant> scalarFunctions();

        public abstract List<AggregateFunctionVariant> aggregateFunctions();

        public abstract List<WindowFunctionVariant> windowFunctions();

        public static ImmutableSimpleExtension.ExtensionCollection.Builder builder() {
            return ImmutableSimpleExtension.ExtensionCollection.builder();
        }

        public Type getType(TypeAnchor anchor) {
            Type type = this.typeLookup.get().get(anchor);
            if (type != null) {
                return type;
            }
            this.checkUrn(anchor.urn());
            throw new IllegalArgumentException(String.format("Unexpected type with name %s. The URN %s is loaded but no type with this name found.", anchor.key(), anchor.urn()));
        }

        public ScalarFunctionVariant getScalarFunction(FunctionAnchor anchor) {
            ScalarFunctionVariant variant = this.scalarFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkUrn(anchor.urn());
            throw new IllegalArgumentException(String.format("Unexpected scalar function with key %s. The URN %s is loaded but no scalar function with this key found.", anchor.key(), anchor.urn()));
        }

        private void checkUrn(String name) {
            if (this.urnSupplier.get().contains(name)) {
                return;
            }
            throw new IllegalArgumentException(String.format("Received a reference for extension %s but that extension is not currently loaded.", name));
        }

        public AggregateFunctionVariant getAggregateFunction(FunctionAnchor anchor) {
            AggregateFunctionVariant variant = this.aggregateFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkUrn(anchor.urn());
            throw new IllegalArgumentException(String.format("Unexpected aggregate function with key %s. The URN %s is loaded but no aggregate function with this key was found.", anchor.key(), anchor.urn()));
        }

        public WindowFunctionVariant getWindowFunction(FunctionAnchor anchor) {
            WindowFunctionVariant variant = this.windowFunctionsLookup.get().get(anchor);
            if (variant != null) {
                return variant;
            }
            this.checkUrn(anchor.urn());
            throw new IllegalArgumentException(String.format("Unexpected window aggregate function with key %s. The URN %s is loaded but no window aggregate function with this key was found.", anchor.key(), anchor.urn()));
        }

        String getUriFromUrn(String urn) {
            return this.uriUrnMap().reverseGet(urn);
        }

        String getUrnFromUri(String uri) {
            return this.uriUrnMap().get(uri);
        }

        public ExtensionCollection merge(ExtensionCollection extensionCollection) {
            BidiMap<String, String> mergedUriUrnMap = new BidiMap<String, String>();
            mergedUriUrnMap.merge(this.uriUrnMap());
            mergedUriUrnMap.merge(extensionCollection.uriUrnMap());
            return ImmutableSimpleExtension.ExtensionCollection.builder().addAllAggregateFunctions(this.aggregateFunctions()).addAllAggregateFunctions(extensionCollection.aggregateFunctions()).addAllScalarFunctions(this.scalarFunctions()).addAllScalarFunctions(extensionCollection.scalarFunctions()).addAllWindowFunctions(this.windowFunctions()).addAllWindowFunctions(extensionCollection.windowFunctions()).addAllTypes(this.types()).addAllTypes(extensionCollection.types()).uriUrnMap(mergedUriUrnMap).build();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.ExtensionSignatures.class)
    @JsonSerialize(as=ImmutableSimpleExtension.ExtensionSignatures.class)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @Value.Immutable
    public static abstract class ExtensionSignatures {
        @JsonProperty(value="types")
        public abstract List<Type> types();

        @JsonProperty(value="urn")
        public abstract String urn();

        @JsonProperty(value="scalar_functions")
        public abstract List<ScalarFunction> scalars();

        @JsonProperty(value="aggregate_functions")
        public abstract List<AggregateFunction> aggregates();

        @JsonProperty(value="window_functions")
        public abstract List<WindowFunction> windows();

        public int size() {
            return (this.types() == null ? 0 : this.types().size()) + (this.scalars() == null ? 0 : this.scalars().size()) + (this.aggregates() == null ? 0 : this.aggregates().size()) + (this.windows() == null ? 0 : this.windows().size());
        }

        public Stream<Function> resolve(String urn) {
            return Stream.concat(Stream.concat(this.scalars() == null ? Stream.of(new Function[0]) : this.scalars().stream().flatMap(f -> f.resolve(urn)), this.aggregates() == null ? Stream.of(new Function[0]) : this.aggregates().stream().flatMap(f -> f.resolve(urn))), this.windows() == null ? Stream.of(new Function[0]) : this.windows().stream().flatMap(f -> f.resolve(urn)));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.WindowFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.WindowFunctionVariant.class)
    @Value.Immutable
    public static abstract class WindowFunctionVariant
    extends Function {
        @JsonProperty(value="decomposable")
        @Value.Default
        public Decomposability decomposability() {
            return Decomposability.NONE;
        }

        public abstract @Nullable TypeExpression intermediate();

        @JsonProperty(value="window_type")
        @Value.Default
        public WindowType windowType() {
            return WindowType.PARTITION;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        WindowFunctionVariant resolve(String urn, String name, String description) {
            return ImmutableSimpleExtension.WindowFunctionVariant.builder().urn(urn).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).decomposability(this.decomposability()).intermediate(this.intermediate()).returnType(this.returnType()).windowType(this.windowType()).build();
        }

        public static ImmutableSimpleExtension.WindowFunctionVariant.Builder builder() {
            return ImmutableSimpleExtension.WindowFunctionVariant.builder();
        }
    }

    public static abstract class Function {
        private final Supplier<FunctionAnchor> anchorSupplier = Util.memoize(() -> FunctionAnchor.of(this.urn(), this.key()));
        private final Supplier<String> keySupplier = Util.memoize(() -> Function.constructKey(this.name(), this.args()));
        private final Supplier<List<Argument>> requiredArgsSupplier = Util.memoize(() -> this.args().stream().filter(Argument::required).collect(Collectors.toList()));

        @Value.Default
        public String name() {
            return "";
        }

        @Value.Default
        public String urn() {
            return "";
        }

        public abstract Optional<VariadicBehavior> variadic();

        @Value.Default
        public @Nullable String description() {
            return "";
        }

        public abstract List<Argument> args();

        public abstract Map<String, Option> options();

        public List<Argument> requiredArguments() {
            return this.requiredArgsSupplier.get();
        }

        public String toString() {
            return this.key();
        }

        @Value.Default
        public Nullability nullability() {
            return Nullability.MIRROR;
        }

        public abstract @Nullable Boolean ordered();

        public FunctionAnchor getAnchor() {
            return this.anchorSupplier.get();
        }

        @JsonProperty(value="return")
        public abstract TypeExpression returnType();

        public static String constructKeyFromTypes(String name, List<io.substrait.type.Type> arguments) {
            try {
                return name + ":" + arguments.stream().map(t -> t.accept(ToTypeString.INSTANCE)).collect(Collectors.joining("_"));
            }
            catch (UnsupportedOperationException ex) {
                throw new UnsupportedOperationException(String.format("Failure converting types of function %s.", name), ex);
            }
        }

        public static String constructKey(String name, List<Argument> arguments) {
            try {
                return name + ":" + arguments.stream().map(Argument::toTypeString).collect(Collectors.joining("_"));
            }
            catch (UnsupportedOperationException ex) {
                throw new UnsupportedOperationException(String.format("Failure converting types of function %s.", name), ex);
            }
        }

        public Util.IntRange getRange() {
            int max = this.variadic().map(t -> {
                OptionalInt optionalMax = t.getMax();
                IntStream stream = optionalMax.isPresent() ? IntStream.of(optionalMax.getAsInt()) : IntStream.empty();
                return stream.map(x -> this.args().size() - 1 + x + 1).findFirst().orElse(Integer.MAX_VALUE);
            }).orElse(this.args().size() + 1);
            int min = this.variadic().map(t -> this.args().size() - 1 + t.getMin()).orElse(this.requiredArguments().size());
            return Util.IntRange.of(min, max);
        }

        public void validateOutputType(List<Expression> argumentExpressions, io.substrait.type.Type outputType) {
        }

        public String key() {
            return this.keySupplier.get();
        }

        public io.substrait.type.Type resolveType(List<io.substrait.type.Type> argumentTypes) {
            return TypeExpressionEvaluator.evaluateExpression(this.returnType(), this.args(), argumentTypes);
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.AggregateFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.AggregateFunctionVariant.class)
    @Value.Immutable
    public static abstract class AggregateFunctionVariant
    extends Function {
        @JsonProperty(value="decomposable")
        @Value.Default
        public Decomposability decomposability() {
            return Decomposability.NONE;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        public abstract @Nullable TypeExpression intermediate();

        AggregateFunctionVariant resolve(String urn, String name, String description) {
            return ImmutableSimpleExtension.AggregateFunctionVariant.builder().urn(urn).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).decomposability(this.decomposability()).intermediate(this.intermediate()).returnType(this.returnType()).build();
        }
    }

    public static enum Decomposability {
        NONE,
        ONE,
        MANY;

    }

    public static enum WindowType {
        PARTITION,
        STREAMING;

    }

    @JsonDeserialize(as=ImmutableSimpleExtension.WindowFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.WindowFunction.class)
    @Value.Immutable
    public static abstract class WindowFunction {
        public abstract @Nullable String name();

        public abstract @Nullable String description();

        public abstract List<WindowFunctionVariant> impls();

        public Stream<WindowFunctionVariant> resolve(String urn) {
            return this.impls().stream().map(f -> f.resolve(urn, this.name(), this.description()));
        }

        public static ImmutableSimpleExtension.WindowFunction.Builder builder() {
            return ImmutableSimpleExtension.WindowFunction.builder();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.AggregateFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.AggregateFunction.class)
    @Value.Immutable
    public static abstract class AggregateFunction {
        public abstract @Nullable String name();

        public abstract @Nullable String description();

        public abstract List<AggregateFunctionVariant> impls();

        public Stream<AggregateFunctionVariant> resolve(String urn) {
            return this.impls().stream().map(f -> f.resolve(urn, this.name(), this.description()));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.ScalarFunction.class)
    @JsonSerialize(as=ImmutableSimpleExtension.ScalarFunction.class)
    @Value.Immutable
    public static abstract class ScalarFunction {
        public abstract String name();

        public abstract @Nullable String description();

        public abstract List<ScalarFunctionVariant> impls();

        public Stream<ScalarFunctionVariant> resolve(String urn) {
            return this.impls().stream().map(f -> f.resolve(urn, this.name(), this.description()));
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.Type.class)
    @JsonSerialize(as=ImmutableSimpleExtension.Type.class)
    @Value.Immutable
    public static abstract class Type {
        private final Supplier<TypeAnchor> anchorSupplier = Util.memoize(() -> TypeAnchor.of(this.urn(), this.name()));

        public abstract String name();

        public abstract Optional<String> description();

        @JacksonInject(value="urn")
        public abstract String urn();

        protected abstract Optional<Object> structure();

        protected abstract Optional<List<Object>> parameters();

        protected abstract Optional<Boolean> variadic();

        public TypeAnchor getAnchor() {
            return this.anchorSupplier.get();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.ScalarFunctionVariant.class)
    @JsonSerialize(as=ImmutableSimpleExtension.ScalarFunctionVariant.class)
    @Value.Immutable
    public static abstract class ScalarFunctionVariant
    extends Function {
        public ScalarFunctionVariant resolve(String urn, String name, String description) {
            return ImmutableSimpleExtension.ScalarFunctionVariant.builder().urn(urn).name(name).description(description).nullability(this.nullability()).args(this.args()).options(this.options()).ordered(this.ordered()).variadic(this.variadic()).returnType(this.returnType()).build();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.VariadicBehavior.class)
    @JsonSerialize(as=ImmutableSimpleExtension.VariadicBehavior.class)
    @Value.Immutable
    public static interface VariadicBehavior {
        public int getMin();

        public OptionalInt getMax();

        default public ParameterConsistency parameterConsistency() {
            return ParameterConsistency.CONSISTENT;
        }

        public static enum ParameterConsistency {
            CONSISTENT,
            INCONSISTENT;

        }
    }

    @Value.Immutable
    public static interface TypeAnchor
    extends Anchor {
        public static TypeAnchor of(String urn, String name) {
            return ImmutableSimpleExtension.TypeAnchor.builder().urn(urn).key(name).build();
        }
    }

    @Value.Immutable
    public static interface FunctionAnchor
    extends Anchor {
        public static FunctionAnchor of(String urn, String key) {
            return ImmutableSimpleExtension.FunctionAnchor.builder().urn(urn).key(key).build();
        }
    }

    public static interface Anchor {
        public String urn();

        public String key();
    }

    @JsonSerialize(as=ImmutableSimpleExtension.EnumArgument.class)
    @JsonDeserialize(as=ImmutableSimpleExtension.EnumArgument.class)
    @Value.Immutable
    public static abstract class EnumArgument
    implements Argument {
        @JsonProperty(required=true)
        public abstract List<String> options();

        @Override
        public boolean required() {
            return true;
        }

        @Override
        public String toTypeString() {
            return "req";
        }

        public static ImmutableSimpleExtension.EnumArgument.Builder builder() {
            return ImmutableSimpleExtension.EnumArgument.builder();
        }
    }

    @JsonSerialize(as=ImmutableSimpleExtension.TypeArgument.class)
    @JsonDeserialize(as=ImmutableSimpleExtension.TypeArgument.class)
    @Value.Immutable
    public static abstract class TypeArgument
    implements Argument {
        @JsonProperty(required=true)
        public abstract ParameterizedType type();

        @Override
        public String toTypeString() {
            return "type";
        }

        @Override
        public boolean required() {
            return true;
        }

        public static ImmutableSimpleExtension.TypeArgument.Builder builder() {
            return ImmutableSimpleExtension.TypeArgument.builder();
        }
    }

    @JsonSerialize(as=ImmutableSimpleExtension.ValueArgument.class)
    @JsonDeserialize(as=ImmutableSimpleExtension.ValueArgument.class)
    @Value.Immutable
    public static abstract class ValueArgument
    implements Argument {
        @JsonProperty(required=true)
        public abstract ParameterizedType value();

        @JsonProperty
        public abstract @Nullable Boolean constant();

        @Override
        public String toTypeString() {
            return this.value().accept(ToTypeString.INSTANCE);
        }

        @Override
        public boolean required() {
            return true;
        }

        public static ImmutableSimpleExtension.ValueArgument.Builder builder() {
            return ImmutableSimpleExtension.ValueArgument.builder();
        }
    }

    @JsonDeserialize(as=ImmutableSimpleExtension.Option.class)
    @JsonSerialize(as=ImmutableSimpleExtension.Option.class)
    @Value.Immutable
    public static interface Option {
        public Optional<String> getDescription();

        public List<String> getValues();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ValueArgument.class), @JsonSubTypes.Type(value=TypeArgument.class), @JsonSubTypes.Type(value=EnumArgument.class)})
    public static interface Argument {
        public String toTypeString();

        @JsonProperty
        public @Nullable String name();

        @JsonProperty
        public @Nullable String description();

        public boolean required();
    }

    public static enum Nullability {
        MIRROR,
        DECLARED_OUTPUT,
        DISCRETE;

    }
}

