/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.relation;

import com.google.protobuf.Any;
import io.substrait.expression.Expression;
import io.substrait.expression.ImmutableExpression;
import io.substrait.expression.proto.ProtoExpressionConverter;
import io.substrait.extension.AdvancedExtension;
import io.substrait.extension.DefaultExtensionCatalog;
import io.substrait.extension.ExtensionLookup;
import io.substrait.extension.ProtoExtensionConverter;
import io.substrait.extension.SimpleExtension;
import io.substrait.hint.Hint;
import io.substrait.hint.ImmutableHint;
import io.substrait.hint.ImmutableRuntimeConstraint;
import io.substrait.hint.ImmutableStats;
import io.substrait.plan.Plan;
import io.substrait.proto.AggregateRel;
import io.substrait.proto.ConsistentPartitionWindowRel;
import io.substrait.proto.CrossRel;
import io.substrait.proto.DdlRel;
import io.substrait.proto.ExpandRel;
import io.substrait.proto.Expression;
import io.substrait.proto.ExtensionLeafRel;
import io.substrait.proto.ExtensionMultiRel;
import io.substrait.proto.ExtensionSingleRel;
import io.substrait.proto.FetchRel;
import io.substrait.proto.FilterRel;
import io.substrait.proto.HashJoinRel;
import io.substrait.proto.JoinRel;
import io.substrait.proto.MergeJoinRel;
import io.substrait.proto.NamedStruct;
import io.substrait.proto.NestedLoopJoinRel;
import io.substrait.proto.ProjectRel;
import io.substrait.proto.ReadRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import io.substrait.proto.RelRoot;
import io.substrait.proto.SetRel;
import io.substrait.proto.SortRel;
import io.substrait.proto.Type;
import io.substrait.proto.UpdateRel;
import io.substrait.proto.WriteRel;
import io.substrait.relation.AbstractDdlRel;
import io.substrait.relation.AbstractUpdate;
import io.substrait.relation.AbstractWriteRel;
import io.substrait.relation.Aggregate;
import io.substrait.relation.ConsistentPartitionWindow;
import io.substrait.relation.Cross;
import io.substrait.relation.EmptyScan;
import io.substrait.relation.Expand;
import io.substrait.relation.Extension;
import io.substrait.relation.ExtensionDdl;
import io.substrait.relation.ExtensionLeaf;
import io.substrait.relation.ExtensionMulti;
import io.substrait.relation.ExtensionSingle;
import io.substrait.relation.ExtensionTable;
import io.substrait.relation.ExtensionWrite;
import io.substrait.relation.Fetch;
import io.substrait.relation.Filter;
import io.substrait.relation.ImmutableAggregate;
import io.substrait.relation.ImmutableConsistentPartitionWindow;
import io.substrait.relation.ImmutableCross;
import io.substrait.relation.ImmutableEmptyScan;
import io.substrait.relation.ImmutableExpand;
import io.substrait.relation.ImmutableExtensionDdl;
import io.substrait.relation.ImmutableExtensionLeaf;
import io.substrait.relation.ImmutableExtensionMulti;
import io.substrait.relation.ImmutableExtensionSingle;
import io.substrait.relation.ImmutableExtensionTable;
import io.substrait.relation.ImmutableExtensionWrite;
import io.substrait.relation.ImmutableFetch;
import io.substrait.relation.ImmutableFilter;
import io.substrait.relation.ImmutableGrouping;
import io.substrait.relation.ImmutableJoin;
import io.substrait.relation.ImmutableLocalFiles;
import io.substrait.relation.ImmutableMeasure;
import io.substrait.relation.ImmutableNamedDdl;
import io.substrait.relation.ImmutableNamedScan;
import io.substrait.relation.ImmutableNamedUpdate;
import io.substrait.relation.ImmutableNamedWrite;
import io.substrait.relation.ImmutableProject;
import io.substrait.relation.ImmutableSet;
import io.substrait.relation.ImmutableSort;
import io.substrait.relation.ImmutableTransformExpression;
import io.substrait.relation.ImmutableVirtualTableScan;
import io.substrait.relation.Join;
import io.substrait.relation.LocalFiles;
import io.substrait.relation.NamedDdl;
import io.substrait.relation.NamedScan;
import io.substrait.relation.NamedUpdate;
import io.substrait.relation.NamedWrite;
import io.substrait.relation.Project;
import io.substrait.relation.ProtoAggregateFunctionConverter;
import io.substrait.relation.Rel;
import io.substrait.relation.Set;
import io.substrait.relation.Sort;
import io.substrait.relation.VirtualTableScan;
import io.substrait.relation.extensions.EmptyDetail;
import io.substrait.relation.files.FileFormat;
import io.substrait.relation.files.FileOrFiles;
import io.substrait.relation.files.ImmutableFileFormat;
import io.substrait.relation.files.ImmutableFileOrFiles;
import io.substrait.relation.physical.HashJoin;
import io.substrait.relation.physical.ImmutableHashJoin;
import io.substrait.relation.physical.ImmutableMergeJoin;
import io.substrait.relation.physical.ImmutableNestedLoopJoin;
import io.substrait.relation.physical.MergeJoin;
import io.substrait.relation.physical.NestedLoopJoin;
import io.substrait.type.ImmutableType;
import io.substrait.type.Type;
import io.substrait.type.proto.ProtoTypeConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

public class ProtoRelConverter {
    protected final @NonNull ExtensionLookup lookup;
    protected final @NonNull SimpleExtension.ExtensionCollection extensions;
    protected final @NonNull ProtoTypeConverter protoTypeConverter;
    protected final @NonNull ProtoExtensionConverter protoExtensionConverter;

    public ProtoRelConverter(@NonNull ExtensionLookup lookup) {
        this(lookup, DefaultExtensionCatalog.DEFAULT_COLLECTION);
    }

    public ProtoRelConverter(@NonNull ExtensionLookup lookup, @NonNull SimpleExtension.ExtensionCollection extensions) {
        this(lookup, extensions, new ProtoExtensionConverter());
    }

    public ProtoRelConverter(@NonNull ExtensionLookup lookup, @NonNull ProtoExtensionConverter protoExtensionConverter) {
        this(lookup, DefaultExtensionCatalog.DEFAULT_COLLECTION, protoExtensionConverter);
    }

    public ProtoRelConverter(@NonNull ExtensionLookup lookup, @NonNull SimpleExtension.ExtensionCollection extensions, @NonNull ProtoExtensionConverter protoExtensionConverter) {
        if (lookup == null) {
            throw new IllegalArgumentException("ExtensionLookup is required");
        }
        if (extensions == null) {
            throw new IllegalArgumentException("ExtensionCollection is required");
        }
        if (protoExtensionConverter == null) {
            throw new IllegalArgumentException("ProtoExtensionConverter is required");
        }
        this.lookup = lookup;
        this.extensions = extensions;
        this.protoTypeConverter = new ProtoTypeConverter(lookup, extensions);
        this.protoExtensionConverter = protoExtensionConverter;
    }

    public Plan.Root from(RelRoot rel) {
        return Plan.Root.builder().input(this.from(rel.getInput())).addAllNames((Iterable<String>)rel.getNamesList()).build();
    }

    public Rel from(io.substrait.proto.Rel rel) {
        Rel.RelTypeCase relType = rel.getRelTypeCase();
        switch (relType) {
            case READ: {
                return this.newRead(rel.getRead());
            }
            case FILTER: {
                return this.newFilter(rel.getFilter());
            }
            case FETCH: {
                return this.newFetch(rel.getFetch());
            }
            case AGGREGATE: {
                return this.newAggregate(rel.getAggregate());
            }
            case SORT: {
                return this.newSort(rel.getSort());
            }
            case JOIN: {
                return this.newJoin(rel.getJoin());
            }
            case SET: {
                return this.newSet(rel.getSet());
            }
            case PROJECT: {
                return this.newProject(rel.getProject());
            }
            case EXPAND: {
                return this.newExpand(rel.getExpand());
            }
            case CROSS: {
                return this.newCross(rel.getCross());
            }
            case EXTENSION_LEAF: {
                return this.newExtensionLeaf(rel.getExtensionLeaf());
            }
            case EXTENSION_SINGLE: {
                return this.newExtensionSingle(rel.getExtensionSingle());
            }
            case EXTENSION_MULTI: {
                return this.newExtensionMulti(rel.getExtensionMulti());
            }
            case HASH_JOIN: {
                return this.newHashJoin(rel.getHashJoin());
            }
            case MERGE_JOIN: {
                return this.newMergeJoin(rel.getMergeJoin());
            }
            case NESTED_LOOP_JOIN: {
                return this.newNestedLoopJoin(rel.getNestedLoopJoin());
            }
            case WINDOW: {
                return this.newConsistentPartitionWindow(rel.getWindow());
            }
            case WRITE: {
                return this.newWrite(rel.getWrite());
            }
            case DDL: {
                return this.newDdl(rel.getDdl());
            }
            case UPDATE: {
                return this.newUpdate(rel.getUpdate());
            }
        }
        throw new UnsupportedOperationException("Unsupported RelTypeCase of " + (Object)((Object)relType));
    }

    protected Rel newRead(ReadRel rel) {
        if (rel.hasVirtualTable()) {
            ReadRel.VirtualTable virtualTable = rel.getVirtualTable();
            if (virtualTable.getValuesCount() == 0) {
                return this.newEmptyScan(rel);
            }
            return this.newVirtualTable(rel);
        }
        if (rel.hasNamedTable()) {
            return this.newNamedScan(rel);
        }
        if (rel.hasLocalFiles()) {
            return this.newLocalFiles(rel);
        }
        if (rel.hasExtensionTable()) {
            return this.newExtensionTable(rel);
        }
        return this.newEmptyScan(rel);
    }

    protected Rel newWrite(WriteRel rel) {
        WriteRel.WriteTypeCase relType = rel.getWriteTypeCase();
        switch (relType) {
            case NAMED_TABLE: {
                return this.newNamedWrite(rel);
            }
            case EXTENSION_TABLE: {
                return this.newExtensionWrite(rel);
            }
        }
        throw new UnsupportedOperationException("Unsupported WriteTypeCase of " + (Object)((Object)relType));
    }

    protected NamedWrite newNamedWrite(WriteRel rel) {
        Rel input = this.from(rel.getInput());
        ImmutableNamedWrite.Builder builder = NamedWrite.builder().input(input).names((Iterable<String>)rel.getNamedTable().getNamesList()).tableSchema(this.newNamedStruct(rel.getTableSchema())).createMode(AbstractWriteRel.CreateMode.fromProto(rel.getCreateMode())).outputMode(AbstractWriteRel.OutputMode.fromProto(rel.getOutput())).operation(AbstractWriteRel.WriteOp.fromProto(rel.getOp()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Rel newExtensionWrite(WriteRel rel) {
        Rel input = this.from(rel.getInput());
        Extension.WriteExtensionObject detail = this.detailFromWriteExtensionObject(rel.getExtensionTable().getDetail());
        ImmutableExtensionWrite.Builder builder = ExtensionWrite.builder().input(input).detail(detail).tableSchema(this.newNamedStruct(rel.getTableSchema())).createMode(AbstractWriteRel.CreateMode.fromProto(rel.getCreateMode())).outputMode(AbstractWriteRel.OutputMode.fromProto(rel.getOutput())).operation(AbstractWriteRel.WriteOp.fromProto(rel.getOp()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Rel newDdl(DdlRel rel) {
        DdlRel.WriteTypeCase relType = rel.getWriteTypeCase();
        switch (relType) {
            case NAMED_OBJECT: {
                return this.newNamedDdl(rel);
            }
            case EXTENSION_OBJECT: {
                return this.newExtensionDdl(rel);
            }
        }
        throw new UnsupportedOperationException("Unsupported WriteTypeCase of " + (Object)((Object)relType));
    }

    protected NamedDdl newNamedDdl(DdlRel rel) {
        io.substrait.type.NamedStruct tableSchema = this.newNamedStruct(rel.getTableSchema());
        ImmutableNamedDdl.Builder builder = NamedDdl.builder().names((Iterable<String>)rel.getNamedObject().getNamesList()).tableSchema(tableSchema).tableDefaults(this.tableDefaults(rel.getTableDefaults(), tableSchema)).operation(AbstractDdlRel.DdlOp.fromProto(rel.getOp())).object(AbstractDdlRel.DdlObject.fromProto(rel.getObject())).viewDefinition(this.optionalViewDefinition(rel)).commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected ExtensionDdl newExtensionDdl(DdlRel rel) {
        Extension.DdlExtensionObject detail = this.detailFromDdlExtensionObject(rel.getExtensionObject().getDetail());
        io.substrait.type.NamedStruct tableSchema = this.newNamedStruct(rel.getTableSchema());
        ImmutableExtensionDdl.Builder builder = ExtensionDdl.builder().detail(detail).tableSchema(this.newNamedStruct(rel.getTableSchema())).tableDefaults(this.tableDefaults(rel.getTableDefaults(), tableSchema)).operation(AbstractDdlRel.DdlOp.fromProto(rel.getOp())).object(AbstractDdlRel.DdlObject.fromProto(rel.getObject())).viewDefinition(this.optionalViewDefinition(rel)).commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Optional<Rel> optionalViewDefinition(DdlRel rel) {
        return Optional.ofNullable(rel.hasViewDefinition() ? this.from(rel.getViewDefinition()) : null);
    }

    protected Expression.StructLiteral tableDefaults(Expression.Literal.Struct struct, io.substrait.type.NamedStruct tableSchema) {
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, tableSchema.struct(), this);
        return Expression.StructLiteral.builder().fields(struct.getFieldsList().stream().map(converter::from).collect(Collectors.toList())).build();
    }

    protected Rel newUpdate(UpdateRel rel) {
        UpdateRel.UpdateTypeCase relType = rel.getUpdateTypeCase();
        switch (relType) {
            case NAMED_TABLE: {
                return this.newNamedUpdate(rel);
            }
        }
        throw new UnsupportedOperationException("Unsupported UpdateTypeCase of " + (Object)((Object)relType));
    }

    protected Rel newNamedUpdate(UpdateRel rel) {
        io.substrait.type.NamedStruct tableSchema = this.newNamedStruct(rel.getTableSchema());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, tableSchema.struct(), this);
        ArrayList<ImmutableTransformExpression> transformations = new ArrayList<ImmutableTransformExpression>(rel.getTransformationsCount());
        for (UpdateRel.TransformExpression transformation : rel.getTransformationsList()) {
            transformations.add(AbstractUpdate.TransformExpression.builder().transformation(converter.from(transformation.getTransformation())).columnTarget(transformation.getColumnTarget()).build());
        }
        ImmutableNamedUpdate.Builder builder = NamedUpdate.builder().names((Iterable<String>)rel.getNamedTable().getNamesList()).tableSchema(tableSchema).addAllTransformations(transformations).condition(converter.from(rel.getCondition()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Filter newFilter(FilterRel rel) {
        Rel input = this.from(rel.getInput());
        ImmutableFilter.Builder builder = Filter.builder().input(input).condition(new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this).from(rel.getCondition()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected io.substrait.type.NamedStruct newNamedStruct(ReadRel rel) {
        return this.newNamedStruct(rel.getBaseSchema());
    }

    protected io.substrait.type.NamedStruct newNamedStruct(NamedStruct namedStruct) {
        Type.Struct struct = namedStruct.getStruct();
        return io.substrait.type.NamedStruct.builder().names((Iterable<String>)namedStruct.getNamesList()).struct(Type.Struct.builder().fields(struct.getTypesList().stream().map(this.protoTypeConverter::from).collect(Collectors.toList())).nullable(ProtoTypeConverter.isNullable(struct.getNullability())).build()).build();
    }

    protected EmptyScan newEmptyScan(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        ImmutableEmptyScan.Builder builder = EmptyScan.builder().initialSchema(namedStruct).bestEffortFilter(Optional.ofNullable(rel.hasBestEffortFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getBestEffortFilter()) : null)).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected ExtensionLeaf newExtensionLeaf(ExtensionLeafRel rel) {
        Extension.LeafRelDetail detail = this.detailFromExtensionLeafRel(rel.getDetail());
        ImmutableExtensionLeaf.Builder builder = ExtensionLeaf.from(detail).commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        return builder.build();
    }

    protected ExtensionSingle newExtensionSingle(ExtensionSingleRel rel) {
        Extension.SingleRelDetail detail = this.detailFromExtensionSingleRel(rel.getDetail());
        Rel input = this.from(rel.getInput());
        ImmutableExtensionSingle.Builder builder = ExtensionSingle.from(detail, input).commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        return builder.build();
    }

    protected ExtensionMulti newExtensionMulti(ExtensionMultiRel rel) {
        Extension.MultiRelDetail detail = this.detailFromExtensionMultiRel(rel.getDetail());
        List<Rel> inputs = rel.getInputsList().stream().map(this::from).collect(Collectors.toList());
        ImmutableExtensionMulti.Builder builder = ExtensionMulti.from(detail, inputs).commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasDetail()) {
            builder.detail(this.detailFromExtensionMultiRel(rel.getDetail()));
        }
        return builder.build();
    }

    protected NamedScan newNamedScan(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        ImmutableNamedScan.Builder builder = NamedScan.builder().initialSchema(namedStruct).names((Iterable<String>)rel.getNamedTable().getNamesList()).bestEffortFilter(Optional.ofNullable(rel.hasBestEffortFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getBestEffortFilter()) : null)).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected ExtensionTable newExtensionTable(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        Extension.ExtensionTableDetail detail = this.detailFromExtensionTable(rel.getExtensionTable().getDetail());
        ImmutableExtensionTable.Builder builder = ExtensionTable.from(detail).initialSchema(namedStruct);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected LocalFiles newLocalFiles(ReadRel rel) {
        io.substrait.type.NamedStruct namedStruct = this.newNamedStruct(rel);
        ImmutableLocalFiles.Builder builder = LocalFiles.builder().initialSchema(namedStruct).addAllItems(rel.getLocalFiles().getItemsList().stream().map(this::newFileOrFiles).collect(Collectors.toList())).bestEffortFilter(Optional.ofNullable(rel.hasBestEffortFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getBestEffortFilter()) : null)).filter(Optional.ofNullable(rel.hasFilter() ? new ProtoExpressionConverter(this.lookup, this.extensions, namedStruct.struct(), this).from(rel.getFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected FileOrFiles newFileOrFiles(ReadRel.LocalFiles.FileOrFiles file) {
        ImmutableFileOrFiles.Builder builder = FileOrFiles.builder().partitionIndex(file.getPartitionIndex()).start(file.getStart()).length(file.getLength());
        if (file.hasParquet()) {
            builder.fileFormat(FileFormat.ParquetReadOptions.builder().build());
        } else if (file.hasOrc()) {
            builder.fileFormat(FileFormat.OrcReadOptions.builder().build());
        } else if (file.hasArrow()) {
            builder.fileFormat(FileFormat.ArrowReadOptions.builder().build());
        } else if (file.hasDwrf()) {
            builder.fileFormat(FileFormat.DwrfReadOptions.builder().build());
        } else if (file.hasText()) {
            ImmutableFileFormat.DelimiterSeparatedTextReadOptions.Builder ffBuilder = FileFormat.DelimiterSeparatedTextReadOptions.builder().fieldDelimiter(file.getText().getFieldDelimiter()).maxLineSize(file.getText().getMaxLineSize()).quote(file.getText().getQuote()).headerLinesToSkip(file.getText().getHeaderLinesToSkip()).escape(file.getText().getEscape());
            if (file.getText().hasValueTreatedAsNull()) {
                ffBuilder.valueTreatedAsNull(file.getText().getValueTreatedAsNull());
            }
            builder.fileFormat(ffBuilder.build());
        } else if (file.hasExtension()) {
            builder.fileFormat(FileFormat.Extension.builder().extension(file.getExtension()).build());
        }
        if (file.hasUriFile()) {
            builder.pathType(FileOrFiles.PathType.URI_FILE).path(file.getUriFile());
        } else if (file.hasUriFolder()) {
            builder.pathType(FileOrFiles.PathType.URI_FOLDER).path(file.getUriFolder());
        } else if (file.hasUriPath()) {
            builder.pathType(FileOrFiles.PathType.URI_PATH).path(file.getUriPath());
        } else if (file.hasUriPathGlob()) {
            builder.pathType(FileOrFiles.PathType.URI_PATH_GLOB).path(file.getUriPathGlob());
        }
        return builder.build();
    }

    protected VirtualTableScan newVirtualTable(ReadRel rel) {
        ReadRel.VirtualTable virtualTable = rel.getVirtualTable();
        io.substrait.type.NamedStruct virtualTableSchema = this.newNamedStruct(rel);
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, virtualTableSchema.struct(), this);
        ArrayList<ImmutableExpression.StructLiteral> structLiterals = new ArrayList<ImmutableExpression.StructLiteral>(virtualTable.getValuesCount());
        for (Expression.Literal.Struct struct : virtualTable.getValuesList()) {
            structLiterals.add(Expression.StructLiteral.builder().fields(struct.getFieldsList().stream().map(converter::from).collect(Collectors.toList())).build());
        }
        ImmutableVirtualTableScan.Builder builder = VirtualTableScan.builder().bestEffortFilter(Optional.ofNullable(rel.hasBestEffortFilter() ? converter.from(rel.getBestEffortFilter()) : null)).filter(Optional.ofNullable(rel.hasFilter() ? converter.from(rel.getFilter()) : null)).initialSchema(io.substrait.type.NamedStruct.fromProto(rel.getBaseSchema(), this.protoTypeConverter)).rows(structLiterals);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Fetch newFetch(FetchRel rel) {
        Rel input = this.from(rel.getInput());
        ImmutableFetch.Builder builder = Fetch.builder().input(input).offset(rel.getOffset());
        if (rel.getCount() != -1L) {
            builder.count(rel.getCount());
        }
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Project newProject(ProjectRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        ImmutableProject.Builder builder = Project.builder().input(input).expressions(rel.getExpressionsList().stream().map(converter::from).collect(Collectors.toList()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Expand newExpand(ExpandRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        ImmutableExpand.Builder builder = Expand.builder().input(input).fields(rel.getFieldsList().stream().map(expandField -> {
            switch (expandField.getFieldTypeCase()) {
                case CONSISTENT_FIELD: {
                    return Expand.ConsistentField.builder().expression(converter.from(expandField.getConsistentField())).build();
                }
                case SWITCHING_FIELD: {
                    return Expand.SwitchingField.builder().duplicates(expandField.getSwitchingField().getDuplicatesList().stream().map(converter::from).collect(Collectors.toList())).build();
                }
            }
            throw new UnsupportedOperationException("Expand fields not set");
        }).collect(Collectors.toList()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        return builder.build();
    }

    protected Aggregate newAggregate(AggregateRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter protoExprConverter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        ProtoAggregateFunctionConverter protoAggrFuncConverter = new ProtoAggregateFunctionConverter(this.lookup, this.extensions, protoExprConverter);
        ArrayList<ImmutableGrouping> groupings = new ArrayList<ImmutableGrouping>(rel.getGroupingsCount());
        if (!rel.getGroupingExpressionsList().isEmpty()) {
            List allGroupingExpressions = rel.getGroupingExpressionsList().stream().map(protoExprConverter::from).collect(Collectors.toList());
            for (AggregateRel.Grouping grouping : rel.getGroupingsList()) {
                List<Integer> references = grouping.getExpressionReferencesList();
                ArrayList<Expression> groupExpressions = new ArrayList<Expression>();
                for (int ref : references) {
                    groupExpressions.add((Expression)allGroupingExpressions.get(ref));
                }
                groupings.add(Aggregate.Grouping.builder().addAllExpressions(groupExpressions).build());
            }
        } else {
            for (AggregateRel.Grouping grouping : rel.getGroupingsList()) {
                groupings.add(Aggregate.Grouping.builder().expressions(grouping.getGroupingExpressionsList().stream().map(protoExprConverter::from).collect(Collectors.toList())).build());
            }
        }
        ArrayList<ImmutableMeasure> measures = new ArrayList<ImmutableMeasure>(rel.getMeasuresCount());
        for (AggregateRel.Measure measure : rel.getMeasuresList()) {
            measures.add(Aggregate.Measure.builder().function(protoAggrFuncConverter.from(measure.getMeasure())).preMeasureFilter(Optional.ofNullable(measure.hasFilter() ? protoExprConverter.from(measure.getFilter()) : null)).build());
        }
        ImmutableAggregate.Builder builder = Aggregate.builder().input(input).groupings(groupings).measures(measures);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Sort newSort(SortRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        ImmutableSort.Builder builder = Sort.builder().input(input).sortFields(rel.getSortsList().stream().map(field -> Expression.SortField.builder().direction(Expression.SortDirection.fromProto(field.getDirection())).expr(converter.from(field.getExpr())).build()).collect(Collectors.toList()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Join newJoin(JoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct, this);
        ImmutableJoin.Builder builder = Join.builder().left(left).right(right).condition(converter.from(rel.getExpression())).joinType(Join.JoinType.fromProto(rel.getType())).postJoinFilter(Optional.ofNullable(rel.hasPostJoinFilter() ? converter.from(rel.getPostJoinFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Rel newCross(CrossRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        ImmutableCross.Builder builder = Cross.builder().left(left).right(right);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Set newSet(SetRel rel) {
        List inputs = rel.getInputsList().stream().map(inputRel -> this.from((io.substrait.proto.Rel)inputRel)).collect(Collectors.toList());
        ImmutableSet.Builder builder = Set.builder().inputs(inputs).setOp(Set.SetOp.fromProto(rel.getOp()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Rel newHashJoin(HashJoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        List<Expression.FieldReference> leftKeys = rel.getLeftKeysList();
        List<Expression.FieldReference> rightKeys = rel.getRightKeysList();
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter leftConverter = new ProtoExpressionConverter(this.lookup, this.extensions, leftStruct, this);
        ProtoExpressionConverter rightConverter = new ProtoExpressionConverter(this.lookup, this.extensions, rightStruct, this);
        ProtoExpressionConverter unionConverter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct, this);
        ImmutableHashJoin.Builder builder = HashJoin.builder().left(left).right(right).leftKeys(leftKeys.stream().map(leftConverter::from).collect(Collectors.toList())).rightKeys(rightKeys.stream().map(rightConverter::from).collect(Collectors.toList())).joinType(HashJoin.JoinType.fromProto(rel.getType())).postJoinFilter(Optional.ofNullable(rel.hasPostJoinFilter() ? unionConverter.from(rel.getPostJoinFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected Rel newMergeJoin(MergeJoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        List<Expression.FieldReference> leftKeys = rel.getLeftKeysList();
        List<Expression.FieldReference> rightKeys = rel.getRightKeysList();
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter leftConverter = new ProtoExpressionConverter(this.lookup, this.extensions, leftStruct, this);
        ProtoExpressionConverter rightConverter = new ProtoExpressionConverter(this.lookup, this.extensions, rightStruct, this);
        ProtoExpressionConverter unionConverter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct, this);
        ImmutableMergeJoin.Builder builder = MergeJoin.builder().left(left).right(right).leftKeys(leftKeys.stream().map(leftConverter::from).collect(Collectors.toList())).rightKeys(rightKeys.stream().map(rightConverter::from).collect(Collectors.toList())).joinType(MergeJoin.JoinType.fromProto(rel.getType())).postJoinFilter(Optional.ofNullable(rel.hasPostJoinFilter() ? unionConverter.from(rel.getPostJoinFilter()) : null));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected NestedLoopJoin newNestedLoopJoin(NestedLoopJoinRel rel) {
        Rel left = this.from(rel.getLeft());
        Rel right = this.from(rel.getRight());
        Type.Struct leftStruct = left.getRecordType();
        Type.Struct rightStruct = right.getRecordType();
        ImmutableType.Struct unionedStruct = Type.Struct.builder().from(leftStruct).from(rightStruct).build();
        ProtoExpressionConverter converter = new ProtoExpressionConverter(this.lookup, this.extensions, unionedStruct, this);
        ImmutableNestedLoopJoin.Builder builder = NestedLoopJoin.builder().left(left).right(right).condition(rel.hasExpression() ? converter.from(rel.getExpression()) : Expression.BoolLiteral.builder().value(true).build()).joinType(NestedLoopJoin.JoinType.fromProto(rel.getType()));
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected ConsistentPartitionWindow newConsistentPartitionWindow(ConsistentPartitionWindowRel rel) {
        Rel input = this.from(rel.getInput());
        ProtoExpressionConverter protoExpressionConverter = new ProtoExpressionConverter(this.lookup, this.extensions, input.getRecordType(), this);
        List partitionExprs = rel.getPartitionExpressionsList().stream().map(protoExpressionConverter::from).collect(Collectors.toList());
        List sortFields = rel.getSortsList().stream().map(protoExpressionConverter::fromSortField).collect(Collectors.toList());
        List windowRelFunctions = rel.getWindowFunctionsList().stream().map(protoExpressionConverter::fromWindowRelFunction).collect(Collectors.toList());
        ImmutableConsistentPartitionWindow.Builder builder = ConsistentPartitionWindow.builder().input(input).partitionExpressions(partitionExprs).sorts(sortFields).windowFunctions(windowRelFunctions);
        builder.commonExtension(this.optionalAdvancedExtension(rel.getCommon())).remap(ProtoRelConverter.optionalRelmap(rel.getCommon())).hint(this.optionalHint(rel.getCommon()));
        if (rel.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(rel.getAdvancedExtension()));
        }
        return builder.build();
    }

    protected static Optional<Rel.Remap> optionalRelmap(RelCommon relCommon) {
        return Optional.ofNullable(relCommon.hasEmit() ? Rel.Remap.of(relCommon.getEmit().getOutputMappingList()) : null);
    }

    protected Optional<Hint> optionalHint(RelCommon relCommon) {
        if (!relCommon.hasHint()) {
            return Optional.empty();
        }
        RelCommon.Hint hint = relCommon.getHint();
        ImmutableHint.Builder builder = Hint.builder().addAllOutputNames((Iterable<String>)hint.getOutputNamesList());
        if (!hint.getAlias().isEmpty()) {
            builder.alias(hint.getAlias());
        }
        if (hint.hasAdvancedExtension()) {
            builder.extension(this.protoExtensionConverter.fromProto(hint.getAdvancedExtension()));
        }
        if (hint.hasStats()) {
            RelCommon.Hint.Stats stats = hint.getStats();
            ImmutableStats.Builder statsBuilder = Hint.Stats.builder();
            statsBuilder.recordSize(stats.getRecordSize()).rowCount(stats.getRowCount());
            if (stats.hasAdvancedExtension()) {
                statsBuilder.extension(this.protoExtensionConverter.fromProto(stats.getAdvancedExtension()));
            }
            builder.stats(statsBuilder.build());
        }
        if (hint.hasConstraint()) {
            RelCommon.Hint.RuntimeConstraint constraint = hint.getConstraint();
            ImmutableRuntimeConstraint.Builder constraintBuilder = Hint.RuntimeConstraint.builder();
            if (constraint.hasAdvancedExtension()) {
                constraintBuilder.extension(this.protoExtensionConverter.fromProto(constraint.getAdvancedExtension()));
            }
            builder.runtimeConstraint(constraintBuilder.build());
        }
        hint.getLoadedComputationsList().forEach(loadedComp -> builder.addLoadedComputations((Hint.LoadedComputation)Hint.LoadedComputation.builder().computationId(loadedComp.getComputationIdReference()).computationType(Hint.ComputationType.fromProto(loadedComp.getType())).build()));
        hint.getSavedComputationsList().forEach(savedComp -> builder.addSavedComputations((Hint.SavedComputation)Hint.SavedComputation.builder().computationId(savedComp.getComputationId()).computationType(Hint.ComputationType.fromProto(savedComp.getType())).build()));
        return Optional.of(builder.build());
    }

    protected Optional<AdvancedExtension> optionalAdvancedExtension(RelCommon relCommon) {
        return Optional.ofNullable(relCommon.hasAdvancedExtension() ? this.protoExtensionConverter.fromProto(relCommon.getAdvancedExtension()) : null);
    }

    protected Extension.LeafRelDetail detailFromExtensionLeafRel(Any any) {
        return this.emptyDetail();
    }

    protected Extension.SingleRelDetail detailFromExtensionSingleRel(Any any) {
        return this.emptyDetail();
    }

    protected Extension.MultiRelDetail detailFromExtensionMultiRel(Any any) {
        return this.emptyDetail();
    }

    protected Extension.ExtensionTableDetail detailFromExtensionTable(Any any) {
        return this.emptyDetail();
    }

    protected Extension.WriteExtensionObject detailFromWriteExtensionObject(Any any) {
        return this.emptyDetail();
    }

    protected Extension.DdlExtensionObject detailFromDdlExtensionObject(Any any) {
        return this.emptyDetail();
    }

    private EmptyDetail emptyDetail() {
        return new EmptyDetail();
    }
}

