/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.state;

import io.streamthoughts.kafka.connect.filepulse.source.FileObject;
import io.streamthoughts.kafka.connect.filepulse.state.FileObjectStateBackingStoreManager;
import io.streamthoughts.kafka.connect.filepulse.state.internal.OpaqueMemoryResource;
import io.streamthoughts.kafka.connect.filepulse.storage.StateBackingStore;
import java.util.function.Supplier;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateBackingStoreAccess
implements Supplier<OpaqueMemoryResource<StateBackingStore<FileObject>>>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(StateBackingStoreAccess.class);
    private final String name;
    private final OpaqueMemoryResource<StateBackingStore<FileObject>> sharedStore;

    public StateBackingStoreAccess(String name, Supplier<StateBackingStore<FileObject>> supplier, boolean doStart) {
        this.name = name;
        this.sharedStore = this.initSharedStateBackingStore(name, supplier, doStart);
    }

    private OpaqueMemoryResource<StateBackingStore<FileObject>> initSharedStateBackingStore(String name, Supplier<StateBackingStore<FileObject>> supplier, boolean doStart) {
        try {
            LOG.info("Retrieving access to shared backing store");
            return FileObjectStateBackingStoreManager.INSTANCE.getOrCreateSharedStore(name, () -> {
                StateBackingStore store = (StateBackingStore)supplier.get();
                if (doStart) {
                    store.start();
                }
                return store;
            }, new Object());
        }
        catch (Exception exception) {
            throw new ConnectException("Failed to create shared StateBackingStore for group '" + name + "'.", (Throwable)exception);
        }
    }

    @Override
    public void close() {
        try {
            if (this.sharedStore != null) {
                this.sharedStore.close();
            }
        }
        catch (Exception exception) {
            LOG.error("Failed to shared StateBackingStore '{}'", (Object)this.name);
        }
    }

    @Override
    public OpaqueMemoryResource<StateBackingStore<FileObject>> get() {
        return this.sharedStore;
    }
}

