/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.state;

import io.streamthoughts.kafka.connect.filepulse.source.FileObject;
import io.streamthoughts.kafka.connect.filepulse.state.internal.OpaqueMemoryResource;
import io.streamthoughts.kafka.connect.filepulse.state.internal.ResourceDisposer;
import io.streamthoughts.kafka.connect.filepulse.state.internal.ResourceInitializer;
import io.streamthoughts.kafka.connect.filepulse.storage.StateBackingStore;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileObjectStateBackingStoreManager {
    public static final FileObjectStateBackingStoreManager INSTANCE = new FileObjectStateBackingStoreManager();
    private static final Logger LOG = LoggerFactory.getLogger(FileObjectStateBackingStoreManager.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<String, LeasedResource<StateBackingStore<FileObject>>> leasedResources = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpaqueMemoryResource<StateBackingStore<FileObject>> getOrCreateSharedStore(String name, ResourceInitializer<StateBackingStore<FileObject>> initializer, Object leaseHolder) throws Exception {
        this.lock.lock();
        try {
            LeasedResource<StateBackingStore<FileObject>> leasedResource = this.leasedResources.get(name);
            if (leasedResource == null) {
                LOG.info("Initializing shared StateBackingStore '{}'", (Object)name);
                StateBackingStore<FileObject> resource = initializer.apply();
                leasedResource = new LeasedResource<StateBackingStore<FileObject>>(resource);
                this.leasedResources.put(name, leasedResource);
            }
            leasedResource.addLeaseHolder(leaseHolder);
            ResourceDisposer<Exception> disposer = () -> this.release(name, leaseHolder);
            OpaqueMemoryResource<StateBackingStore<FileObject>> opaqueMemoryResource = new OpaqueMemoryResource<StateBackingStore<FileObject>>(leasedResource.getResource(), disposer);
            return opaqueMemoryResource;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(String name, Object leaseHolder) throws Exception {
        this.lock.lock();
        try {
            LeasedResource<StateBackingStore<FileObject>> leasedResource = this.leasedResources.get(name);
            if (leasedResource == null) {
                return;
            }
            String threadName = Thread.currentThread().getName();
            LOG.info("[{}] Releasing access on shared StateBackingStore '{}' instance.", (Object)name, (Object)threadName);
            if (leasedResource.removeLeaseHolder(leaseHolder)) {
                LOG.info("[{}] Closing shared StateBackingStore '{}'", (Object)name, (Object)threadName);
                leasedResource.close();
                this.leasedResources.remove(name);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class LeasedResource<T extends AutoCloseable>
    implements AutoCloseable {
        private final T resource;
        private final HashSet<Object> leaseHolders = new HashSet();
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public LeasedResource(T resource) {
            this.resource = (AutoCloseable)Objects.requireNonNull(resource, "resource should not be null");
        }

        public T getResource() {
            return this.resource;
        }

        void addLeaseHolder(Object leaseHolder) {
            this.leaseHolders.add(leaseHolder);
        }

        boolean removeLeaseHolder(Object leaseHolder) {
            this.leaseHolders.remove(leaseHolder);
            return this.leaseHolders.isEmpty();
        }

        @Override
        public void close() throws Exception {
            if (this.closed.compareAndSet(false, true)) {
                this.resource.close();
            }
        }
    }
}

