/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.TaskPartitioner;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.kafka.common.utils.Utils;

public class HashByURITaskPartitioner
implements TaskPartitioner {
    public List<List<URI>> partition(Collection<FileObjectMeta> files, int taskCount) {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<URI>> partitioned = new ArrayList<List<URI>>(taskCount);
        IntStream.range(0, taskCount).forEachOrdered(i -> partitioned.add(i, new LinkedList()));
        for (FileObjectMeta objectMeta : files) {
            byte[] bytes = objectMeta.stringURI().getBytes(StandardCharsets.UTF_8);
            int taskId = Utils.toPositive((int)Utils.murmur2((byte[])bytes)) % taskCount;
            partitioned.get(taskId).add(objectMeta.uri());
        }
        return partitioned;
    }
}

