/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.source.FileObject;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectContext;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectKey;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectOffset;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectStatus;
import io.streamthoughts.kafka.connect.filepulse.source.StateListener;
import io.streamthoughts.kafka.connect.filepulse.storage.StateBackingStore;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileObjectStateReporter
implements StateListener {
    private static final Logger LOG = LoggerFactory.getLogger(FileObjectStateReporter.class);
    private final StateBackingStore<FileObject> store;

    FileObjectStateReporter(StateBackingStore<FileObject> store) {
        Objects.requireNonNull(store, "store can't be null");
        this.store = store;
    }

    void notify(FileObjectKey key, FileObjectMeta metadata, FileObjectOffset offset, FileObjectStatus status) {
        Objects.requireNonNull(metadata, "metadata can't be null");
        Objects.requireNonNull(offset, "offset can't be null");
        Objects.requireNonNull(status, "status can't be null");
        this.store.putAsync(key.original(), (Object)new FileObject(metadata, offset, status));
    }

    void notify(FileObjectContext context, FileObjectStatus status) {
        this.notify(context.key(), context.metadata(), context.offset(), status);
    }

    public void onScheduled(FileObjectContext context) {
        Objects.requireNonNull(context, "context can't be null");
        LOG.debug("Scheduling object-file: '{}'", (Object)context.metadata());
        this.notify(context, FileObjectStatus.SCHEDULED);
    }

    public void onInvalid(FileObjectContext context) {
        Objects.requireNonNull(context, "context can't be null");
        this.notify(context, FileObjectStatus.INVALID);
    }

    public void onStart(FileObjectContext context) {
        Objects.requireNonNull(context, "context can't be null");
        LOG.debug("Starting to precess object-file: '{}'", (Object)context.metadata());
        this.notify(context, FileObjectStatus.STARTED);
    }

    public void onCompleted(FileObjectContext context) {
        Objects.requireNonNull(context, "context can't be null");
        LOG.debug("Completed object-file: '{}'", (Object)context.metadata());
        this.notify(context, FileObjectStatus.COMPLETED);
    }

    public void onFailure(FileObjectContext context, Throwable t) {
        Objects.requireNonNull(context, "context can't be null");
        LOG.error("Error while processing object-file: '{}'", (Object)context.metadata(), (Object)t);
        this.notify(context, FileObjectStatus.FAILED);
    }
}

