/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.offset;

import io.streamthoughts.kafka.connect.filepulse.annotation.VisibleForTesting;
import io.streamthoughts.kafka.connect.filepulse.errors.ConnectFilePulseException;
import io.streamthoughts.kafka.connect.filepulse.offset.AbstractSourceOffsetPolicy;
import io.streamthoughts.kafka.connect.filepulse.offset.DefaultSourceOffsetPolicyConfig;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSourceOffsetPolicy
extends AbstractSourceOffsetPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSourceOffsetPolicy.class);
    private static final String FILEPATH_FIELD = "path";
    private static final String FILENAME_FIELD = "name";
    private static final String URI_FIELD = "uri";
    private static final String INODE_FIELD = "inode";
    private static final String HASH_FIELD = "hash";
    private static final String MODIFIED_FIELD = "lastmodified";
    private static final Map<String, GenericOffsetPolicy> ATTRIBUTES = new HashMap<String, GenericOffsetPolicy>();
    protected final List<GenericOffsetPolicy> policies = new LinkedList<GenericOffsetPolicy>();
    private String offsetAttributesString;

    public DefaultSourceOffsetPolicy() {
    }

    @VisibleForTesting
    DefaultSourceOffsetPolicy(String offsetAttributesString) {
        this.offsetAttributesString = offsetAttributesString;
        this.parseConfig(offsetAttributesString);
    }

    public void configure(Map<String, ?> configs) {
        this.offsetAttributesString = new DefaultSourceOffsetPolicyConfig(configs).offsets();
        this.parseConfig(this.offsetAttributesString);
    }

    private void parseConfig(String offsetStrategyString) {
        for (String label : offsetStrategyString.split("\\+")) {
            GenericOffsetPolicy strategy = ATTRIBUTES.get(label.toLowerCase());
            if (strategy == null) {
                throw new IllegalArgumentException("Unknown offset policy for name '" + label + "'");
            }
            this.policies.add(strategy);
        }
    }

    public Map<String, Object> toPartitionMap(FileObjectMeta objectMeta) {
        Collections.sort(this.policies);
        LinkedHashMap<String, Object> offset = new LinkedHashMap<String, Object>();
        for (GenericOffsetPolicy policy : this.policies) {
            try {
                policy.addAttributeToPartitionMap(objectMeta, offset);
            }
            catch (Exception e) {
                LOG.error("Unexpected error while building partition map using policy '{}'. Error: {}", (Object)policy.name, (Object)e.getMessage());
                throw e;
            }
        }
        return offset;
    }

    public String toString() {
        return this.offsetAttributesString;
    }

    static {
        int priority = 1;
        ATTRIBUTES.put(FILENAME_FIELD, new GenericOffsetPolicy(FILENAME_FIELD, priority++, FileObjectMeta::name));
        ATTRIBUTES.put(FILEPATH_FIELD, new GenericOffsetPolicy(FILEPATH_FIELD, priority++, objectMeta -> new File(objectMeta.uri()).getParentFile().getAbsolutePath()));
        ATTRIBUTES.put(HASH_FIELD, new GenericOffsetPolicy(HASH_FIELD, priority++, objectMeta -> Optional.ofNullable(objectMeta.contentDigest()).map(FileObjectMeta.ContentDigest::digest).orElseThrow(() -> new IllegalArgumentException("Object file property 'content-digest' is empty"))));
        ATTRIBUTES.put(MODIFIED_FIELD, new GenericOffsetPolicy(MODIFIED_FIELD, priority++, objectMeta -> Optional.ofNullable(objectMeta.lastModified()).orElseThrow(() -> new IllegalArgumentException("Object file property 'last-modified' is empty"))));
        ATTRIBUTES.put(URI_FIELD, new GenericOffsetPolicy(URI_FIELD, priority++, FileObjectMeta::stringURI));
        ATTRIBUTES.put(INODE_FIELD, new GenericOffsetPolicy(INODE_FIELD, priority++, source -> Optional.ofNullable(source.userDefinedMetadata().get("system.inode").toString()).orElseThrow(() -> {
            throw new ConnectFilePulseException("Object file property 'unix-inode' is empty. Unix-inode maybe not supported. Consider configuring a different value for 'offset.attributes.string' [path, name, hash, name, uri]");
        })));
    }

    static final class GenericOffsetPolicy
    implements Comparable<GenericOffsetPolicy> {
        final String name;
        final Function<FileObjectMeta, Object> offsetFunction;
        final int priority;

        GenericOffsetPolicy(String name, int priority, Function<FileObjectMeta, Object> offsetFunction) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
            this.offsetFunction = Objects.requireNonNull(offsetFunction, "offsetFunction cannot be null");
            this.priority = priority;
        }

        void addAttributeToPartitionMap(FileObjectMeta objectMeta, Map<String, Object> offset) {
            offset.put(this.name, this.offsetFunction.apply(objectMeta));
        }

        @Override
        public int compareTo(GenericOffsetPolicy that) {
            return Integer.compare(this.priority, that.priority);
        }
    }
}

