/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.offset;

import io.streamthoughts.kafka.connect.filepulse.errors.ConnectFilePulseException;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectOffset;
import io.streamthoughts.kafka.connect.filepulse.source.SourceOffsetPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.source.SourceTaskContext;

public abstract class AbstractSourceOffsetPolicy
implements SourceOffsetPolicy {
    private static final String POSITION_OFFSET_FIELD = "position";
    private static final String POSITION_ROWS_FIELD = "rows";
    private static final String POSITION_TIMESTAMP_FIELD = "timestamp";

    public Optional<FileObjectOffset> getOffsetFor(SourceTaskContext context, FileObjectMeta source) {
        Object timestamp;
        Map partition = this.toPartitionMap(source);
        Map offset = context.offsetStorageReader().offset(partition);
        Object offsetBytes = offset != null ? offset.get(POSITION_OFFSET_FIELD) : null;
        Object rows = offset != null ? offset.get(POSITION_ROWS_FIELD) : null;
        Object v0 = timestamp = offset != null ? offset.get(POSITION_TIMESTAMP_FIELD) : null;
        if (offsetBytes == null || rows == null || timestamp == null) {
            return Optional.empty();
        }
        this.checkOffsetIsValid(offsetBytes);
        this.checkRowsIsValid(rows);
        this.checkTimestampIsValid(timestamp);
        return Optional.of(new FileObjectOffset(((Long)offsetBytes).longValue(), ((Long)rows).longValue(), ((Long)timestamp).longValue()));
    }

    private void checkTimestampIsValid(Object timestamp) {
        if (!(timestamp instanceof Long)) {
            throw new ConnectFilePulseException("Incorrect type for the last active timestamp");
        }
    }

    private void checkRowsIsValid(Object rows) {
        if (!(rows instanceof Long)) {
            throw new ConnectFilePulseException("Incorrect type for number of rows");
        }
    }

    private void checkOffsetIsValid(Object offsetBytes) {
        if (!(offsetBytes instanceof Long)) {
            throw new ConnectFilePulseException("Incorrect type for position bytes");
        }
    }

    public Map<String, ?> toOffsetMap(FileObjectOffset offset) {
        Objects.requireNonNull(offset, "position can't be null");
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(POSITION_OFFSET_FIELD, offset.position());
        map.put(POSITION_ROWS_FIELD, offset.rows());
        map.put(POSITION_TIMESTAMP_FIELD, offset.timestamp());
        return map;
    }
}

