/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.config;

import io.streamthoughts.kafka.connect.filepulse.clean.FileCleanupPolicy;
import io.streamthoughts.kafka.connect.filepulse.config.CommonSourceConfig;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;

public class SourceConnectorConfig
extends CommonSourceConfig {
    public static final String ALLOW_TASKS_RECONFIG_AFTER_TIMEOUT_MS_CONFIG = "allow.tasks.reconfiguration.after.timeout.ms";
    private static final String ALLOW_TASKS_RECONFIG_AFTER_TIMEOUT_MS_DOC = "Specifies the timeout (in milliseconds) for the connector to allow tasks to be reconfigured when new files are detected, even if some tasks are still being processed.";
    public static final String FS_CLEANUP_POLICY_CLASS_CONFIG = "fs.cleanup.policy.class";
    private static final String FS_CLEANUP_POLICY_CLASS_DOC = "The class used to cleanup files that have been processed by tasks.";
    public static final String[] FS_CLEANUP_POLICY_EXECUTE_VALID_VALUES = new String[]{FileObjectStatus.COMPLETED.name(), FileObjectStatus.COMMITTED.name()};
    public static final String FS_CLEANUP_POLICY_EXECUTE_CONFIG = "fs.cleanup.policy.triggered.on";
    private static final String FS_CLEANUP_POLICY_EXECUTE_DOC = "Specify the status when a file get cleanup. Valid values are: " + Arrays.toString(FS_CLEANUP_POLICY_EXECUTE_VALID_VALUES);
    public static final String FS_LISTING_INTERVAL_MS_CONFIG = "fs.listing.interval.ms";
    private static final String FS_LISTING_INTERVAL_MS_DOC = "The time interval, in milliseconds, in which the connector invokes the scan of the filesystem.";
    private static final long FS_LISTING_INTERVAL_MS_DEFAULT = 10000L;
    public static final String MAX_SCHEDULED_FILES_CONFIG = "max.scheduled.files";
    private static final String MAX_SCHEDULED_FILES_DOC = "Maximum number of files that can be schedules to tasks.";
    private static final int MAX_SCHEDULED_FILES_DEFAULT = 1000;
    public static final String FS_LISTING_TASK_DELEGATION_ENABLED_CONFIG = "fs.listing.task.delegation.enabled";
    private static final String FS_LISTING_TASK_DELEGATION_ENABLED_DOC = "Boolean indicating whether the file listing process should be delegated to tasks.";

    public SourceConnectorConfig(Map<?, ?> originals) {
        super(SourceConnectorConfig.getConf(), originals);
    }

    public static ConfigDef getConf() {
        return CommonSourceConfig.getConfigDev().define(FS_LISTING_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, (Object)10000L, ConfigDef.Importance.HIGH, FS_LISTING_INTERVAL_MS_DOC).define(FS_CLEANUP_POLICY_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, FS_CLEANUP_POLICY_CLASS_DOC).define(ALLOW_TASKS_RECONFIG_AFTER_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, ConfigDef.Importance.MEDIUM, ALLOW_TASKS_RECONFIG_AFTER_TIMEOUT_MS_DOC).define(MAX_SCHEDULED_FILES_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, MAX_SCHEDULED_FILES_DOC).define(FS_LISTING_TASK_DELEGATION_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, FS_LISTING_TASK_DELEGATION_ENABLED_DOC).define(FS_CLEANUP_POLICY_EXECUTE_CONFIG, ConfigDef.Type.STRING, (Object)FileObjectStatus.COMPLETED.name(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])FS_CLEANUP_POLICY_EXECUTE_VALID_VALUES), ConfigDef.Importance.MEDIUM, FS_CLEANUP_POLICY_EXECUTE_DOC);
    }

    public Long allowTasksReconfigurationAfterTimeoutMs() {
        return this.getLong(ALLOW_TASKS_RECONFIG_AFTER_TIMEOUT_MS_CONFIG);
    }

    public int getMaxScheduledFiles() {
        return this.getInt(MAX_SCHEDULED_FILES_CONFIG);
    }

    public FileCleanupPolicy getFsCleanupPolicy() {
        return (FileCleanupPolicy)this.getConfiguredInstance(FS_CLEANUP_POLICY_CLASS_CONFIG, FileCleanupPolicy.class);
    }

    public Predicate<FileObjectStatus> getFsCleanupPolicyPredicate() {
        return objetStatus -> {
            String configureStatusString = this.getString(FS_CLEANUP_POLICY_EXECUTE_CONFIG);
            FileObjectStatus configureStatus = FileObjectStatus.valueOf((String)configureStatusString);
            return objetStatus.isOneOf(new FileObjectStatus[]{FileObjectStatus.FAILED, configureStatus});
        };
    }

    public long getListingInterval() {
        return this.getLong(FS_LISTING_INTERVAL_MS_CONFIG);
    }

    public boolean isFileListingTaskDelegationEnabled() {
        return this.getBoolean(FS_LISTING_TASK_DELEGATION_ENABLED_CONFIG);
    }
}

