/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.storage;

import java.util.Map;
import java.util.Objects;

public class StateSnapshot<T> {
    private final long offset;
    private final Map<String, T> states;

    public StateSnapshot(long offset, Map<String, T> states) {
        Objects.requireNonNull(states, "states can't be null");
        this.offset = offset;
        this.states = states;
    }

    public boolean contains(String key) {
        Objects.requireNonNull(this.states, "key can't be null");
        return this.states.containsKey(key);
    }

    public T getForKey(String key) {
        Objects.requireNonNull(this.states, "key can't be null");
        return this.states.get(key);
    }

    public Map<String, T> states() {
        return this.states;
    }

    public long offset() {
        return this.offset;
    }
}

