/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.storage;

import io.streamthoughts.kafka.connect.filepulse.storage.Callback;
import io.streamthoughts.kafka.connect.filepulse.storage.KafkaBasedLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;

class KafkaBasedLogFactory {
    private final Map<String, ?> configs;

    KafkaBasedLogFactory(Map<String, ?> configs) {
        this.configs = Collections.unmodifiableMap(configs);
    }

    KafkaBasedLog<String, byte[]> make(String topic, Callback<ConsumerRecord<String, byte[]>> consumedCallback) {
        return new KafkaBasedLog<String, byte[]>(topic, this.newProducerConfigs(), this.newConsumerConfigs(), consumedCallback, Time.SYSTEM, null);
    }

    private Map<String, Object> newConsumerConfigs() {
        HashMap<String, Object> consumerProps = new HashMap<String, Object>(this.configs);
        consumerProps.put("key.deserializer", StringDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        return consumerProps;
    }

    private Map<String, Object> newProducerConfigs() {
        HashMap<String, Object> producerProps = new HashMap<String, Object>(this.configs);
        producerProps.put("key.serializer", StringSerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        producerProps.put("retries", Integer.MAX_VALUE);
        return producerProps;
    }
}

