/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.state;

import io.streamthoughts.kafka.connect.filepulse.source.SourceFile;
import io.streamthoughts.kafka.connect.filepulse.storage.StateBackingStore;
import io.streamthoughts.kafka.connect.filepulse.storage.StateStoreProvider;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateBackingStoreRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(StateBackingStoreRegistry.class);
    private static final StateBackingStoreRegistry INSTANCE = new StateBackingStoreRegistry();
    private final Map<String, Integer> refs;
    private final Map<String, StateBackingStore<SourceFile>> stores = new ConcurrentHashMap<String, StateBackingStore<SourceFile>>();

    public static StateBackingStoreRegistry instance() {
        return INSTANCE;
    }

    private StateBackingStoreRegistry() {
        this.refs = new ConcurrentHashMap<String, Integer>();
    }

    public synchronized void register(String name, StateStoreProvider<SourceFile> provider) {
        Objects.requireNonNull(name, "name can't be null");
        Objects.requireNonNull(provider, "provider can't be null");
        LOG.info("Registering new store for name : {}", (Object)name);
        if (!this.has(name)) {
            this.stores.put(name, provider.get());
        } else {
            LOG.info("State store already registered for name : {}", (Object)name);
        }
    }

    public synchronized StateBackingStore<SourceFile> get(String name) {
        Objects.requireNonNull(name, "name can't be null");
        this.checkIfExists(name);
        this.refs.compute(name, (k, v) -> v == null ? 1 : v + 1);
        StateBackingStore<SourceFile> store = this.stores.get(name);
        LOG.info("Getting access on {} instance for group {}", (Object)store.getClass().getSimpleName(), (Object)name);
        return store;
    }

    public synchronized void release(String name) {
        this.checkIfExists(name);
        StateBackingStore<SourceFile> store = this.stores.get(name);
        Integer ref = this.refs.compute(name, (k, v) -> v == null ? null : (v - 1 == 0 ? null : Integer.valueOf(v - 1)));
        String storeClassName = store.getClass().getSimpleName();
        LOG.info("Releasing access on {} instance for group {} (remaining = {})", new Object[]{storeClassName, name, ref});
        if (ref == null) {
            LOG.info("Stopping instance registered instance {} for group {}", (Object)storeClassName, (Object)name);
            store.stop();
            this.stores.remove(name);
        }
    }

    boolean has(String name) {
        return this.stores.containsKey(name);
    }

    private void checkIfExists(String name) {
        if (!this.stores.containsKey(name)) {
            throw new IllegalArgumentException("No store registered for name : " + name);
        }
    }
}

