/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.scanner.FileSystemScanner;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemMonitorThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemMonitorThread.class);
    private static final long SHUTDOWN_TIMEOUT_MS = 5000L;
    private final ConnectorContext context;
    private final CountDownLatch shutdownLatch;
    private final CountDownLatch waitingLatch;
    private final long scanIntervalMs;
    private final FileSystemScanner scanner;

    FileSystemMonitorThread(ConnectorContext context, FileSystemScanner scanner, long scanIntervalMs) {
        super(FileSystemMonitorThread.class.getSimpleName());
        Objects.requireNonNull(context, "context can't be null");
        Objects.requireNonNull(scanner, "scanner can't be null");
        if (scanIntervalMs < 0L) {
            throw new IllegalArgumentException("Invalid Argument - scanInternalMs cannot be inferior to 0");
        }
        this.context = context;
        this.scanner = scanner;
        this.scanIntervalMs = scanIntervalMs;
        this.shutdownLatch = new CountDownLatch(1);
        this.waitingLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOG.info("Starting thread monitoring filesystem.");
            while (this.shutdownLatch.getCount() > 0L) {
                long started = Time.SYSTEM.milliseconds();
                try {
                    this.scanner.scan(this.context);
                }
                catch (Exception e) {
                    LOG.error("Unexpected error while scanning file system.", (Throwable)e);
                    this.context.raiseError(e);
                    throw e;
                }
                long timeout = Math.abs(this.scanIntervalMs - (Time.SYSTEM.milliseconds() - started));
                LOG.info("Waiting {} ms to scan for new files.", (Object)timeout);
                boolean shuttingDown = this.shutdownLatch.await(timeout, TimeUnit.MILLISECONDS);
                if (!shuttingDown) continue;
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("Unexpected InterruptedException, ignoring: ", (Throwable)e);
        }
        finally {
            LOG.info("Stopped thread monitoring filesystem.");
            this.waitingLatch.countDown();
        }
    }

    void shutdown() {
        this.shutdown(5000L);
    }

    void shutdown(long timeoutMs) {
        LOG.info("Shutting down thread monitoring filesystem.");
        this.shutdownLatch.countDown();
        try {
            this.waitingLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignore) {
            LOG.error("Timeout : scan loop is not terminated yet.");
        }
    }
}

