/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local.filter;

import io.streamthoughts.kafka.connect.filepulse.scanner.local.filter.AbstractFileListFilter;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexFileListFilter
extends AbstractFileListFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RegexFileListFilter.class);
    private static final String FILE_FILTER_REGEX_PATTERN_CONFIG = "file.filter.regex.pattern";
    private static final String FILE_FILTER_REGEX_PATTERN_DOC = "The regex pattern used to matches input files";
    private Pattern pattern;

    @Override
    public void configure(Map<String, ?> config) {
        AbstractConfig abstractConfig = new AbstractConfig(RegexFileListFilter.getConfigDef(), config, false);
        String pattern = abstractConfig.getString(FILE_FILTER_REGEX_PATTERN_CONFIG);
        if (pattern == null) {
            throw new ConfigException("missing configuration: file.filter.regex.pattern");
        }
        this.setPattern(pattern);
    }

    private void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    protected boolean accept(File file) {
        if (file == null) {
            return false;
        }
        boolean matched = this.pattern.matcher(file.getName()).matches();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Matching input file name {} to regex {}, matched = {}", new Object[]{file.getName(), this.pattern, matched});
        }
        return matched;
    }

    private static ConfigDef getConfigDef() {
        return new ConfigDef().define(FILE_FILTER_REGEX_PATTERN_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, FILE_FILTER_REGEX_PATTERN_DOC);
    }
}

