/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local.filter;

import io.streamthoughts.kafka.connect.filepulse.scanner.local.filter.AbstractFileListFilter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastModifiedFileListFilter
extends AbstractFileListFilter {
    private static final String FILE_MINIMUM_AGE_MS_CONF = "file.filter.minimum.age.ms";
    private static final String FILE_MINIMUM_AGE_MS_DOC = "Last modified time for a file can be accepted (default: 5000)";
    private static final int FILE_MINIMUM_AGE_MS_DEFAULT = 5000;
    private static final Logger LOG = LoggerFactory.getLogger(LastModifiedFileListFilter.class);
    private long minimumAgeMs;

    @Override
    public void configure(Map<String, ?> props) {
        AbstractConfig abstractConfig = new AbstractConfig(LastModifiedFileListFilter.getConfigDef(), props);
        this.minimumAgeMs = abstractConfig.getLong(FILE_MINIMUM_AGE_MS_CONF);
    }

    @Override
    protected boolean accept(File file) {
        boolean accepted = LastModifiedFileListFilter.isNotModifiedForMs(file, this.minimumAgeMs);
        if (!accepted) {
            LOG.debug("Filtering file {} - doesn't matches minimum age of {}.", (Object)file.getName(), (Object)this.minimumAgeMs);
        }
        return accepted;
    }

    private static ConfigDef getConfigDef() {
        return new ConfigDef().define(FILE_MINIMUM_AGE_MS_CONF, ConfigDef.Type.LONG, (Object)5000, ConfigDef.Importance.HIGH, FILE_MINIMUM_AGE_MS_DOC);
    }

    private static boolean isNotModifiedForMs(File f, long minimumAgeMs) {
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), LinkOption.NOFOLLOW_LINKS);
            long lastModifiedTimeMs = lastModifiedTime.to(TimeUnit.MILLISECONDS);
            long currentTimeMs = System.currentTimeMillis();
            return currentTimeMs - lastModifiedTimeMs > minimumAgeMs;
        }
        catch (IOException e) {
            return false;
        }
    }
}

