/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local.filter;

import io.streamthoughts.kafka.connect.filepulse.scanner.local.FileListFilter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeFileListFilter
implements FileListFilter,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeFileListFilter.class);
    private final Collection<FileListFilter> filters;

    public CompositeFileListFilter(Collection<FileListFilter> filters) {
        this.filters = filters;
    }

    @Override
    public void configure(Map<String, ?> config) {
    }

    @Override
    public Collection<File> filterFiles(Collection<File> files) {
        LOG.debug("Starting to apply filters on source files '{}' files", (Object)files.size());
        long started = Time.SYSTEM.milliseconds();
        HashSet<File> results = new HashSet<File>(files);
        this.filters.forEach(f -> {
            LOG.debug("Apply filter {}", (Object)f.getClass().getSimpleName());
            Collection<File> currentFiltered = f.filterFiles(files);
            results.retainAll(currentFiltered);
        });
        LOG.debug("Finished to filter files - execution took {}ms", (Object)(Time.SYSTEM.milliseconds() - started));
        return results;
    }

    @Override
    public void close() throws IOException {
        for (FileListFilter f : this.filters) {
            if (!(f instanceof Closeable)) continue;
            ((Closeable)((Object)f)).close();
        }
    }
}

