/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local.codec;

import io.streamthoughts.kafka.connect.filepulse.internal.IOUtils;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecHandler;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecHandlerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipCodec
implements CodecHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ZipCodec.class);
    private static final Set<String> MIME_TYPES = new HashSet<String>();

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public boolean canRead(File file) {
        Objects.requireNonNull(file, "file can't be null");
        try {
            String type = Files.probeContentType(file.toPath());
            return MIME_TYPES.contains(type);
        }
        catch (IOException e) {
            LOG.warn("Unexpected error occurred while proving content-type for file : {}", (Object)file.getAbsolutePath());
            return false;
        }
    }

    @Override
    public File decompress(File file) throws IOException {
        File parent = IOUtils.createDirectoryFromFile((File)file);
        try (ZipInputStream inputStream = new ZipInputStream(new FileInputStream(file));){
            ZipEntry zipEntry;
            while ((zipEntry = inputStream.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (zipEntry.isDirectory()) continue;
                String entryDir = IOUtils.getParentDirectoryPath((String)entryName);
                if (entryDir != null) {
                    Files.createDirectories(Paths.get(parent.getAbsolutePath(), entryDir), new FileAttribute[0]);
                }
                CodecHandlerUtils.decompress(inputStream, parent.getAbsolutePath(), entryName);
            }
        }
        catch (IOException e) {
            LOG.error("Error while extracting file {}", (Object)file.getName(), (Object)e);
        }
        return parent;
    }

    static {
        MIME_TYPES.add("application/x-zip-compressed");
        MIME_TYPES.add("application/zip");
    }
}

