/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local.codec;

import io.streamthoughts.kafka.connect.filepulse.internal.IOUtils;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecHandler;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecHandlerUtils;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.GZipCodec;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarballCodec
implements CodecHandler {
    private static Logger LOG = LoggerFactory.getLogger(GZipCodec.class);
    private static final String TAR_GZ_SUFFIX = ".tar.gz";
    private static final Set<String> MIME_TYPES = new HashSet<String>();

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public boolean canRead(File file) {
        Objects.requireNonNull(file, "file can't be null");
        try {
            String type = Files.probeContentType(file.toPath());
            return MIME_TYPES.contains(type) || file.getName().contains(TAR_GZ_SUFFIX);
        }
        catch (IOException e) {
            LOG.warn("Unexpected error occurred while proving content-type for file : {}", (Object)file.getAbsolutePath());
            return false;
        }
    }

    @Override
    public File decompress(File file) throws IOException {
        File parent = IOUtils.createDirectoryFromFile((File)file);
        try (TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)new FileInputStream(file));){
            ArchiveEntry entry;
            while ((entry = inputStream.getNextEntry()) != null) {
                Path parentPath;
                String entryName = entry.getName();
                if (entry.isDirectory()) continue;
                String entryDir = IOUtils.getParentDirectoryPath((String)entryName);
                if (entryDir != null && !Files.exists(parentPath = Paths.get(parent.getAbsolutePath(), entryDir), new LinkOption[0])) {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                CodecHandlerUtils.decompress((InputStream)inputStream, parent.getAbsolutePath(), entryName);
            }
        }
        catch (IOException e) {
            LOG.error("Error while extracting file {}", (Object)file.getName(), (Object)e);
        }
        return parent;
    }

    static {
        MIME_TYPES.add("application/x-tar");
    }
}

