/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local.codec;

import io.streamthoughts.kafka.connect.filepulse.internal.IOUtils;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecHandler;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecHandlerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipCodec
implements CodecHandler {
    private static Logger LOG = LoggerFactory.getLogger(GZipCodec.class);
    private static final Set<String> MIME_TYPES = new HashSet<String>();

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public boolean canRead(File file) {
        Objects.requireNonNull(file, "file can't be null");
        try {
            String type = Files.probeContentType(file.toPath());
            return MIME_TYPES.contains(type);
        }
        catch (IOException e) {
            LOG.warn("Unexpected error occurred while proving content-type for file : {}", (Object)file.getAbsolutePath());
            return false;
        }
    }

    @Override
    public File decompress(File file) throws IOException {
        File parent = IOUtils.createDirectoryFromFile((File)file);
        try (GZIPInputStream inputStream = new GZIPInputStream(new FileInputStream(file));){
            CodecHandlerUtils.decompress(inputStream, parent.getAbsolutePath(), IOUtils.getNameWithoutExtension((File)file));
        }
        catch (IOException e) {
            LOG.error("Error while extracting file {}", (Object)file.getName(), (Object)e);
        }
        return parent;
    }

    static {
        MIME_TYPES.add("application/x-gzip");
    }
}

