/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local.codec;

import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecHandler;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.GZipCodec;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.TarballCodec;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.ZipCodec;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecManager {
    private static final Logger LOG = LoggerFactory.getLogger(CodecManager.class);
    private List<CodecHandler> codecs = new LinkedList<CodecHandler>();

    public CodecManager() {
        this.register(new ZipCodec());
        this.register(new GZipCodec());
        this.register(new TarballCodec());
    }

    private void register(CodecHandler codec) {
        LOG.info("Added codec '{}'", codec.getClass());
        this.codecs.add(codec);
    }

    public CodecHandler getCodecIfCompressedOrNull(File file) {
        Optional<CodecHandler> optional = this.codecs.stream().filter(c -> c.canRead(file)).findFirst();
        return optional.orElse(null);
    }
}

