/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local.codec;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CodecHandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CodecHandlerUtils.class);
    private static final int DEFAULT_BYTES_BUFFER_SIZE = 1024;

    CodecHandlerUtils() {
    }

    static void decompress(InputStream inputStream, String parent, String name) throws IOException {
        block9: {
            File file = new File(parent, name);
            if (!Files.exists(file.toPath(), new LinkOption[0])) {
                String path = file.getAbsolutePath();
                LOG.debug("Decompressing file : {}", (Object)path);
                byte[] buffer = new byte[1024];
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
                    int bytesCount;
                    while ((bytesCount = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesCount);
                    }
                    LOG.debug("File decompressed successfully : {}", (Object)path);
                    break block9;
                }
                catch (IOException e) {
                    LOG.error("Unexpected error while decompressing file entry {} to directory {}", new Object[]{name, parent, e});
                    throw e;
                }
            }
            LOG.debug("File already decompressed : {}", (Object)file.getName());
        }
    }
}

