/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.scanner.local;

import io.streamthoughts.kafka.connect.filepulse.scanner.local.FSDirectoryWalker;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.FileListFilter;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.LocalFSDirectoryWalkerConfig;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecHandler;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.codec.CodecManager;
import io.streamthoughts.kafka.connect.filepulse.scanner.local.filter.CompositeFileListFilter;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFSDirectoryWalker
implements FSDirectoryWalker {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFSDirectoryWalker.class);
    private FileListFilter filter;
    private CodecManager codecs;
    private LocalFSDirectoryWalkerConfig config;

    public LocalFSDirectoryWalker() {
        this(Collections.emptyList());
    }

    public LocalFSDirectoryWalker(List<FileListFilter> filters) {
        Objects.requireNonNull(filters, "filters can't be null");
        this.filter = new CompositeFileListFilter(filters);
        this.codecs = new CodecManager();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.config = new LocalFSDirectoryWalkerConfig(configs);
    }

    @Override
    public Collection<File> listFiles(File dir) throws IllegalArgumentException {
        List<File> files = this.listEligibleFiles(dir);
        return this.filter != null ? this.filter.filterFiles(files) : files;
    }

    @Override
    public void setFilter(FileListFilter filter) {
        this.filter = filter;
    }

    private List<File> listEligibleFiles(File input) {
        LinkedList<File> listingLocalFiles = new LinkedList<File>();
        if (!this.isReadableAndNotHidden(input)) {
            if (!input.isHidden()) {
                LOG.warn("File doesn't exist or can't be read: {}", (Object)input.getAbsolutePath());
            }
            return listingLocalFiles;
        }
        LinkedList decompressedDirs = new LinkedList();
        LinkedList directories = new LinkedList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(input.toPath());){
            stream.forEach(path -> {
                File file = path.toFile();
                try {
                    if (file.isFile()) {
                        CodecHandler codec = this.codecs.getCodecIfCompressedOrNull(file);
                        if (codec != null) {
                            LOG.debug("Detecting compressed file : {}", (Object)file.getCanonicalPath());
                            File decompressed = codec.decompress(file);
                            listingLocalFiles.addAll(this.listEligibleFiles(decompressed));
                            decompressedDirs.add(decompressed);
                        } else {
                            listingLocalFiles.add(file);
                        }
                    } else {
                        directories.add(file);
                    }
                }
                catch (IOException e) {
                    LOG.error("Skip input file {} - error while decompressing", (Object)file.getName(), (Object)e);
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Error while listing directory {}: {}", (Object)input.getAbsolutePath(), (Object)e.getLocalizedMessage());
            throw new ConnectException((Throwable)e);
        }
        if (this.config.isRecursiveScanEnable()) {
            listingLocalFiles.addAll(directories.stream().filter(f -> !decompressedDirs.contains(f)).flatMap(f -> this.listEligibleFiles((File)f).stream()).collect(Collectors.toList()));
        }
        return listingLocalFiles;
    }

    private boolean isReadableAndNotHidden(File file) {
        return file.exists() && file.canRead() && !file.isHidden();
    }
}

