/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader.internal;

import java.nio.charset.Charset;
import java.util.Objects;

public class TextBlock {
    private final String data;
    private final long startOffset;
    private final long endOffset;
    private final int size;
    private final Charset charset;

    TextBlock(String data, Charset charset, long startOffset, long endOffset, int size) {
        this.data = data;
        this.charset = charset;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.size = size;
    }

    public String data() {
        return this.data;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public int size() {
        return this.size;
    }

    public Charset charset() {
        return this.charset;
    }

    public byte[] toByteArray() {
        return this.data.getBytes(this.charset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextBlock)) {
            return false;
        }
        TextBlock textBlock = (TextBlock)o;
        return this.startOffset == textBlock.startOffset && this.endOffset == textBlock.endOffset && this.size == textBlock.size && Objects.equals(this.data, textBlock.data) && Objects.equals(this.charset, textBlock.charset);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.startOffset, this.endOffset, this.size, this.charset);
    }

    public String toString() {
        return "TextBlock{value='" + this.data + '\'' + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", size=" + this.size + ", charset=" + this.charset + '}';
    }
}

