/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader.internal;

import io.streamthoughts.kafka.connect.filepulse.reader.internal.TextBlock;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public class ReversedInputFileReader
implements AutoCloseable {
    static final int DEFAULT_INITIAL_CAPACITY = 4096;
    private static final String READ_MODE = "r";
    private static final String EMPTY_LINE = "";
    private static final int LF = 10;
    private static final int CR = 13;
    private RandomAccessFile input;
    private long position;
    private long offset;
    private int bufferEndOffset;
    private final long length;
    private final Charset charset;
    private byte[] buffer;
    private int bufferOffset;
    private int remaining;

    public ReversedInputFileReader(String path, Charset charset) throws IOException {
        this(path, 4096, charset);
    }

    ReversedInputFileReader(String path, int initialCapacity, Charset charset) throws IOException {
        File inputFile = new File(path);
        this.length = inputFile.length();
        this.charset = charset;
        this.input = new RandomAccessFile(path, READ_MODE);
        this.buffer = new byte[(long)initialCapacity > this.length ? (int)this.length : initialCapacity];
        this.position = this.length;
        this.remaining = this.bufferOffset = this.bufferLength();
        this.offset = this.position;
    }

    private void seekTo(long offset) throws IOException {
        if (this.isInvalidOffset(offset)) {
            throw new IllegalArgumentException("Invalid Offset, can't seek to startPosition " + offset);
        }
        this.position = offset;
        this.input.seek(offset);
    }

    private boolean isInvalidOffset(long offset) {
        return offset < 0L || offset > this.length;
    }

    public List<TextBlock> readLines(int minRecords) throws IOException {
        if (this.isInvalidOffset(this.position)) {
            return null;
        }
        LinkedList<TextBlock> records = new LinkedList<TextBlock>();
        while (this.hasNext() && (records.isEmpty() || records.size() < minRecords)) {
            TextBlock line;
            int nread = this.bufferOffset;
            long nextPosition = Math.max(0L, this.position - (long)nread);
            if (nextPosition == 0L && (long)this.bufferLength() > this.position) {
                this.resizeBuffer((int)this.position + this.remaining);
                nread = (int)this.position + 1;
                this.remaining = this.bufferLength();
            }
            this.bufferEndOffset = this.bufferLength() - 1;
            this.seekTo(nextPosition);
            this.input.readFully(this.buffer, 0, nread);
            this.bufferOffset = 0;
            do {
                if ((line = this.tryToExtractLine()) == null || line.size() <= 0) continue;
                records.add(line);
            } while (line != null && records.size() < minRecords);
            if (!records.isEmpty() || this.bufferOffset != 0) continue;
            int prevSize = this.bufferLength();
            this.resizeBuffer(this.bufferLength() * 2);
            this.bufferOffset = this.bufferLength() - prevSize;
        }
        return records;
    }

    private int bufferLength() {
        return this.buffer.length;
    }

    private void resizeBuffer(int size) {
        byte[] newbuf = new byte[size];
        int length = this.bufferLength() - this.bufferOffset;
        System.arraycopy(this.buffer, this.bufferOffset, newbuf, size - length, length);
        this.buffer = newbuf;
    }

    private TextBlock tryToExtractLine() {
        int newline = -1;
        int newStart = -1;
        for (int i = this.bufferEndOffset; i > this.bufferOffset; --i) {
            if (this.buffer[i] != 10) continue;
            newline = i;
            newStart = i - 1;
            if (i - 1 < this.bufferOffset) break;
            newStart = this.buffer[i - 1] == 13 ? i - 2 : i - 1;
            break;
        }
        if (newline != -1) {
            int nread = this.bufferEndOffset - newline;
            String line = nread > 0 ? new String(this.buffer, newline + 1, nread, this.charset) : EMPTY_LINE;
            TextBlock result = new TextBlock(line, this.charset, this.offset - (long)nread, this.offset, nread);
            this.remaining = newStart - this.bufferOffset + 1;
            System.arraycopy(this.buffer, this.bufferOffset, this.buffer, this.bufferLength() - this.remaining, this.remaining);
            this.bufferOffset = this.bufferLength() - this.remaining;
            this.offset -= (long)(this.bufferEndOffset - newStart);
            return result;
        }
        if (this.position == 0L && this.remaining > 0) {
            String line = new String(this.buffer, this.bufferOffset, this.remaining, this.charset);
            TextBlock result = new TextBlock(line, this.charset, 0L, this.remaining, this.remaining);
            this.remaining = 0;
            this.offset = 0;
            this.bufferOffset = this.bufferLength();
            return result;
        }
        return null;
    }

    boolean hasNext() {
        return this.position > 0L || this.remaining > 0;
    }

    @Override
    public void close() throws Exception {
        if (this.input != null) {
            this.input.close();
        }
    }
}

