/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader.internal;

import io.streamthoughts.kafka.connect.filepulse.reader.ReaderException;
import io.streamthoughts.kafka.connect.filepulse.reader.internal.TextBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingBufferReader
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NonBlockingBufferReader.class);
    public static final int DEFAULT_INITIAL_CAPACITY = 4096;
    private final InputStream stream;
    private final int initialCapacity;
    private final Charset charset;
    private BufferedReader reader;
    private Long offset = 0L;
    private char[] buffer;
    private int bufferOffset = 0;
    private int nread = -1;
    private boolean isAutoFlushOnEOF = true;

    public NonBlockingBufferReader(File file, Charset charset) {
        this(file, 4096, charset);
    }

    public NonBlockingBufferReader(File file, int initialCapacity, Charset charset) {
        Objects.requireNonNull(file, "file can't be null");
        this.initialCapacity = initialCapacity;
        this.buffer = new char[initialCapacity];
        this.charset = charset;
        try {
            LOG.debug("Opening file {}", (Object)file);
            this.stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ReaderException("Can't found source file : " + file);
        }
        this.reader = new BufferedReader(new InputStreamReader(this.stream, charset));
    }

    public Charset charset() {
        return this.charset;
    }

    public long position() {
        return this.offset;
    }

    public void enableAutoFlush() {
        this.isAutoFlushOnEOF = true;
    }

    public void disableAutoFlush() {
        this.isAutoFlushOnEOF = false;
    }

    public List<TextBlock> readLines(int minRecords, boolean strict) throws IOException {
        boolean isEOF;
        LinkedList<TextBlock> records = new LinkedList<TextBlock>();
        this.nread = 0;
        boolean maxNumRecordsNotReached = true;
        while (this.reader.ready() && (records.isEmpty() || records.size() < minRecords)) {
            this.nread = this.reader.read(this.buffer, this.bufferOffset, this.buffer.length - this.bufferOffset);
            if (this.nread <= 0) continue;
            this.bufferOffset += this.nread;
            maxNumRecordsNotReached = this.fillWithBufferedLinesUntil(records, minRecords, strict);
            if (!records.isEmpty() || this.bufferOffset != this.buffer.length) continue;
            char[] newbuf = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.buffer.length);
            this.buffer = newbuf;
        }
        boolean bl = isEOF = !this.reader.ready();
        if (isEOF && maxNumRecordsNotReached && strict) {
            maxNumRecordsNotReached = this.fillWithBufferedLinesUntil(records, minRecords, true);
        }
        if (isEOF && maxNumRecordsNotReached && this.remaining()) {
            LOG.info("End of file reached - flushing remaining bytes from reader buffer ({}).", (Object)this.isAutoFlushOnEOF);
            if (this.isAutoFlushOnEOF) {
                String line = new String(this.buffer, 0, this.bufferOffset);
                records.add(new TextBlock(line, this.charset, this.offset, this.offset + (long)this.bufferOffset, this.bufferOffset));
                this.offset = this.offset + (long)this.bufferOffset;
                this.bufferOffset = 0;
            }
        }
        return records;
    }

    private boolean fillWithBufferedLinesUntil(List<TextBlock> records, int minRecords, boolean strict) {
        boolean maxNumRecordsNotReached;
        TextBlock line;
        do {
            if ((line = this.tryToExtractLine()) != null) {
                records.add(line);
            }
            boolean bl = maxNumRecordsNotReached = !strict || records.size() < minRecords;
        } while (line != null && maxNumRecordsNotReached);
        return maxNumRecordsNotReached;
    }

    public boolean remaining() {
        return this.bufferOffset != 0;
    }

    public boolean hasNext() {
        try {
            boolean ready = this.reader.ready();
            if (ready) {
                return true;
            }
            return this.remaining() && this.containsLine();
        }
        catch (IOException e) {
            LOG.error("Error while checking for remaining bytes to read: {}", (Object)e.getLocalizedMessage());
            return false;
        }
    }

    public void seekTo(Long offset) {
        if (offset != null && offset > 0L) {
            long skipped;
            this.buffer = new char[this.initialCapacity];
            LOG.debug("Trying to skip to file offset bytes {}", (Object)offset);
            for (long skipLeft = offset.longValue(); skipLeft > 0L; skipLeft -= skipped) {
                try {
                    skipped = this.reader.skip(skipLeft);
                    continue;
                }
                catch (IOException e) {
                    LOG.error("Error while trying to seek to previous offset bytes in file: ", (Throwable)e);
                    throw new ConnectException((Throwable)e);
                }
            }
            LOG.debug("Skipped to offset bytes {}", (Object)offset);
            this.offset = offset;
        } else {
            this.offset = 0L;
        }
    }

    private boolean containsLine() {
        for (int i = 0; i < this.bufferOffset; ++i) {
            if (this.buffer[i] == '\n') {
                return true;
            }
            if (this.buffer[i] != '\r') continue;
            return i + 1 < this.bufferOffset;
        }
        return false;
    }

    private TextBlock tryToExtractLine() {
        int until = -1;
        int newStart = -1;
        for (int i = 0; i < this.bufferOffset; ++i) {
            if (this.buffer[i] == '\n') {
                until = i;
                newStart = i + 1;
                break;
            }
            if (this.buffer[i] != '\r') continue;
            if (i + 1 >= this.bufferOffset) {
                return null;
            }
            until = i;
            newStart = this.buffer[i + 1] == '\n' ? i + 2 : i + 1;
            break;
        }
        TextBlock result = null;
        if (until != -1) {
            String line = new String(this.buffer, 0, until);
            result = new TextBlock(line, this.charset, this.offset, this.offset + (long)newStart, until);
            System.arraycopy(this.buffer, newStart, this.buffer, 0, this.buffer.length - newStart);
            this.bufferOffset -= newStart;
        }
        if (newStart != -1) {
            this.offset = this.offset + (long)newStart;
        }
        return result;
    }

    @Override
    public void close() {
        try {
            if (this.stream != null && this.stream != System.in) {
                this.stream.close();
                LOG.trace("Closed input stream");
            }
        }
        catch (IOException e) {
            LOG.error("Failed to close NonBlockingBufferReader stream : ", (Throwable)e);
        }
    }
}

