/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class XMLFileInputReaderConfig
extends AbstractConfig {
    public static final String XPATH_QUERY_CONFIG = "xpath.expression";
    private static final String XPATH_QUERY_DOC = "The XPath expression used extract data from XML input files (default: '/')";
    public static final String XPATH_RESULT_TYPE_CONFIG = "xpath.result.type";
    private static final String XPATH_RESULT_TYPE_DOC = "The expected result type for the XPath expression in[NODESET, STRING]";
    public static final String FORCE_ARRAY_ON_FIELDS_CONFIG = "force.array.on.fields";
    private static final String FORCE_ARRAY_ON_FIELDS_FORCE = "The comma-separated list of fields for which an array-type must be forced";

    XMLFileInputReaderConfig(Map<String, ?> originals) {
        super(XMLFileInputReaderConfig.configDef(), originals);
    }

    String xpathQuery() {
        return this.getString(XPATH_QUERY_CONFIG);
    }

    String resultType() {
        return this.getString(XPATH_RESULT_TYPE_CONFIG);
    }

    List<String> forceArrayFields() {
        return this.getList(FORCE_ARRAY_ON_FIELDS_CONFIG);
    }

    private static ConfigDef configDef() {
        return new ConfigDef().define(XPATH_RESULT_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)XPathConstants.NODESET.getLocalPart(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{XPathConstants.NODESET.getLocalPart(), XPathConstants.STRING.getLocalPart()}), ConfigDef.Importance.HIGH, XPATH_RESULT_TYPE_DOC).define(FORCE_ARRAY_ON_FIELDS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, FORCE_ARRAY_ON_FIELDS_FORCE).define(XPATH_QUERY_CONFIG, ConfigDef.Type.STRING, (Object)"/", ConfigDef.Importance.HIGH, XPATH_QUERY_DOC);
    }
}

