/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import io.streamthoughts.kafka.connect.filepulse.data.ArraySchema;
import io.streamthoughts.kafka.connect.filepulse.data.Schema;
import io.streamthoughts.kafka.connect.filepulse.data.SchemaSupplier;
import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedField;
import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.reader.AbstractFileInputIterator;
import io.streamthoughts.kafka.connect.filepulse.reader.AbstractFileInputReader;
import io.streamthoughts.kafka.connect.filepulse.reader.FileInputIterator;
import io.streamthoughts.kafka.connect.filepulse.reader.IteratorManager;
import io.streamthoughts.kafka.connect.filepulse.reader.ReaderException;
import io.streamthoughts.kafka.connect.filepulse.reader.RecordsIterable;
import io.streamthoughts.kafka.connect.filepulse.reader.XMLFileInputReaderConfig;
import io.streamthoughts.kafka.connect.filepulse.reader.XMLRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.source.FileContext;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecord;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.source.SourceOffset;
import io.streamthoughts.kafka.connect.filepulse.source.TypedFileRecord;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLFileInputReader
extends AbstractFileInputReader {
    private XMLFileInputReaderConfig configs;

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = new XMLFileInputReaderConfig(configs);
    }

    @Override
    protected FileInputIterator<FileRecord<TypedStruct>> newIterator(FileContext context, IteratorManager iteratorManager) {
        return new XMLFileInputIterator(this.configs, iteratorManager, context);
    }

    private static class Node2StructConverter {
        private Node2StructConverter() {
        }

        private static TypedStruct convertNodeObjectTree(Node node, List<String> forceArrayFields) {
            Objects.requireNonNull(node, "node cannot be null");
            TypedStruct container = TypedStruct.create();
            Node2StructConverter.readAllNodeAttributes(node, container);
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                Optional<?> optional = Node2StructConverter.readNodeObject(child, forceArrayFields);
                if (!optional.isPresent()) continue;
                Object nodeValue = optional.get();
                String nodeName = Node2StructConverter.isTextNode(child) ? Node2StructConverter.determineNodeName(node) : Node2StructConverter.determineNodeName(child);
                boolean isArray = forceArrayFields.contains(nodeName);
                container = Node2StructConverter.enrichStructWithObject(container, nodeName, nodeValue, isArray);
            }
            return container;
        }

        private static TypedStruct enrichStructWithObject(TypedStruct container, String nodeName, Object nodeValue, boolean forceArrayField) {
            TypedValue value;
            if (container.has(nodeName)) {
                TypedField field = container.field(nodeName);
                if (field.type() == Type.ARRAY) {
                    List array = container.getArray(nodeName);
                    array.add(nodeValue);
                    value = TypedValue.array((Collection)array, (Schema)((ArraySchema)field.schema()).valueSchema());
                } else {
                    LinkedList<Object> array = new LinkedList<Object>();
                    array.add(container.get(nodeName).value());
                    array.add(nodeValue);
                    value = TypedValue.array(array, (Schema)field.schema());
                }
            } else if (forceArrayField) {
                LinkedList<Object> array = new LinkedList<Object>();
                array.add(nodeValue);
                value = TypedValue.array(array, (Schema)SchemaSupplier.lazy((Object)nodeValue).get());
            } else {
                value = TypedValue.any((Object)nodeValue);
            }
            return container.put(nodeName, value);
        }

        private static Optional<?> readNodeObject(Node node, List<String> forceArrayFields) {
            if (Node2StructConverter.isWhitespaceOrNewLineNodeElement(node)) {
                return Optional.empty();
            }
            if (Node2StructConverter.isTextNode(node)) {
                return Optional.of(node.getNodeValue());
            }
            if (Node2StructConverter.isElementNode(node)) {
                Optional<String> childTextContent = Node2StructConverter.peekChildNodeTextContent(node);
                if (childTextContent.isPresent()) {
                    return childTextContent;
                }
                return Optional.of(Node2StructConverter.convertNodeObjectTree(node, forceArrayFields));
            }
            throw new ReaderException("Unsupported node type '" + node.getNodeType() + "'");
        }

        private static Optional<String> peekChildNodeTextContent(Node node) {
            Node child;
            if (!node.hasChildNodes()) {
                return Optional.empty();
            }
            List<Node> nonNewLineNodes = Node2StructConverter.collectAllNotNewLineNodes(node.getChildNodes());
            if (nonNewLineNodes.size() == 1 && Node2StructConverter.isTextNode(child = nonNewLineNodes.get(0))) {
                return Optional.of(child.getTextContent());
            }
            return Optional.empty();
        }

        private static List<Node> collectAllNotNewLineNodes(NodeList nodes) {
            if (nodes.getLength() == 1) {
                return Collections.singletonList(nodes.item(0));
            }
            return IntStream.range(0, nodes.getLength()).mapToObj(nodes::item).filter(it -> !Node2StructConverter.isWhitespaceOrNewLineNodeElement(it)).collect(Collectors.toList());
        }

        private static boolean isTextNode(Node n) {
            return Node2StructConverter.isNodeOfType(n, 3) || Node2StructConverter.isNodeOfType(n, 4);
        }

        private static boolean isElementNode(Node n) {
            return Node2StructConverter.isNodeOfType(n, 1);
        }

        private static boolean isNodeOfType(Node node, int textNode) {
            return node.getNodeType() == textNode;
        }

        private static void readAllNodeAttributes(Node node, TypedStruct values) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes == null) {
                return;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                String attrName = Node2StructConverter.determineNodeName(attr);
                if (!Node2StructConverter.isNotXmlNamespace(attr)) continue;
                values.put(attrName, attr.getNodeValue());
            }
        }

        private static boolean isNotXmlNamespace(Node node) {
            return !"xmlns".equalsIgnoreCase(node.getPrefix());
        }

        private static boolean isWhitespaceOrNewLineNodeElement(Node node) {
            return node != null && Node2StructConverter.isTextNode(node) && node.getTextContent().trim().isEmpty();
        }

        private static String determineNodeName(Node node) {
            return node.getLocalName() != null ? node.getLocalName() : node.getNodeName();
        }
    }

    private static class XMLFileInputIterator
    extends AbstractFileInputIterator<TypedStruct> {
        private final XMLFileInputReaderConfig config;
        private final Object xpathResult;
        private final int totalRecords;
        private int position = 0;
        private final ResultType type;

        XMLFileInputIterator(XMLFileInputReaderConfig config, IteratorManager iteratorManager, FileContext context) {
            super(iteratorManager, context);
            this.config = config;
            System.setProperty("javax.xml.xpath.XPathFactory:http://saxon.sf.net/jaxp/xpath/om", "net.sf.saxon.xpath.XPathFactoryImpl");
            QName qName = new QName("http://www.w3.org/1999/XSL/Transform", config.resultType());
            try (FileInputStream is = new FileInputStream(context.file());){
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setIgnoringElementContentWhitespace(true);
                builderFactory.setIgnoringComments(true);
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(is));
                XPathFactory xPathFactory = XPathFactory.newInstance("http://saxon.sf.net/jaxp/xpath/om");
                XPath expression = xPathFactory.newXPath();
                XPathExpression e = expression.compile(config.xpathQuery());
                this.xpathResult = e.evaluate(document, qName);
            }
            catch (XPathExpressionException e) {
                throw new ReaderException("Cannot compile XPath expression '" + config.xpathQuery() + "'", (Throwable)e);
            }
            catch (IOException e) {
                throw new ReaderException("Error happened while reading source file '" + context + "'", (Throwable)e);
            }
            catch (Exception e) {
                throw new ReaderException("Unexpected error happened while initializing 'XMLFileInputIterator'", (Throwable)e);
            }
            if (XPathConstants.NODESET.equals(qName)) {
                this.type = ResultType.NODE_SET;
                this.totalRecords = ((NodeList)this.xpathResult).getLength();
            } else if (XPathConstants.STRING.equals(qName)) {
                this.type = ResultType.STRING;
                this.totalRecords = 1;
            } else {
                throw new ReaderException("Unsupported result type '" + config.resultType() + "'");
            }
        }

        public void seekTo(SourceOffset offset) {
            Objects.requireNonNull(offset, "offset can't be null");
            if (offset.position() != -1L) {
                this.position = (int)offset.position();
            }
        }

        public RecordsIterable<FileRecord<TypedStruct>> next() {
            if (this.type == ResultType.NODE_SET) {
                Node item = ((NodeList)this.xpathResult).item(this.position);
                if (item == null) {
                    return RecordsIterable.empty();
                }
                try {
                    return this.incrementAndGet(Node2StructConverter.convertNodeObjectTree(item, this.config.forceArrayFields()));
                }
                catch (Exception e) {
                    throw new ReaderException("Fail to convert XML document to connect struct object: " + this.context, (Throwable)e);
                }
            }
            if (this.type == ResultType.STRING) {
                return this.incrementAndGet(TypedStruct.create().put("message", (String)this.xpathResult));
            }
            throw new ReaderException("Unsupported result type '" + (Object)((Object)this.type) + "'");
        }

        private RecordsIterable<FileRecord<TypedStruct>> incrementAndGet(TypedStruct struct) {
            ++this.position;
            return RecordsIterable.of((Object[])new FileRecord[]{new TypedFileRecord((FileRecordOffset)new XMLRecordOffset(this.position), struct)});
        }

        public boolean hasNext() {
            return this.position < this.totalRecords;
        }

        private static enum ResultType {
            NODE_SET,
            STRING;

        }
    }
}

