/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import io.streamthoughts.kafka.connect.filepulse.reader.BytesRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.source.SourceOffset;
import java.util.Objects;
import org.apache.kafka.common.utils.SystemTime;

public class RowFileRecordOffset
extends BytesRecordOffset {
    private final long rows;
    private final long size;

    public static RowFileRecordOffset empty() {
        return new RowFileRecordOffset(-1L, -1L, 0L, SystemTime.SYSTEM.milliseconds(), 0L);
    }

    public static RowFileRecordOffset with(long startPosition, long endPosition) {
        return new RowFileRecordOffset(startPosition, endPosition, 0L, SystemTime.SYSTEM.milliseconds(), endPosition - startPosition);
    }

    public RowFileRecordOffset(long startPosition, long endPosition, long rows, long timestamp, long size) {
        super(timestamp, startPosition, endPosition);
        this.rows = rows;
        this.size = size;
    }

    public RowFileRecordOffset withSize(long size) {
        return new RowFileRecordOffset(this.startPosition(), this.endPosition(), this.rows, this.timestamp(), size);
    }

    public RowFileRecordOffset withRowNumber(long number) {
        return new RowFileRecordOffset(this.startPosition(), this.endPosition(), number, this.timestamp(), this.size);
    }

    public long rows() {
        return this.rows;
    }

    @Override
    public SourceOffset toSourceOffset() {
        return new SourceOffset(this.endPosition(), this.rows, this.timestamp());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowFileRecordOffset)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RowFileRecordOffset that = (RowFileRecordOffset)((Object)o);
        return this.rows == that.rows && this.size == that.size;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rows, this.size);
    }

    @Override
    public String toString() {
        return "[startPosition=" + this.startPosition() + ", endPosition=" + this.endPosition() + ", rows=" + this.rows + ", timestamp=" + this.timestamp() + ", size=" + this.size + ']';
    }
}

