/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

class RowFileInputReaderConfig
extends AbstractConfig {
    public static final String FILE_ENCODING_CONFIG = "file.encoding";
    public static final String FILE_ENCODING_DOC = "The text file encoding to use (default = UTF_8)";
    public static final String FILE_ENCODING_DEFAULT = StandardCharsets.UTF_8.displayName();
    public static final String BUFFER_INIT_BYTES_SIZE_CONFIG = "buffer.initial.bytes.size";
    public static final String BUFFER_INIT_BYTES_SIZE_DOC = "The initial buffer size used to read input files";
    public static final int BUFFER_INIT_BYTES_SIZE_DEFAULT = 4096;
    public static final String MIN_NUM_READ_RECORDS_CONFIG = "min.read.records";
    public static final String MIN_NUM_READ_RECORDS_DOC = "The minimum number of records to read from file before returning to task.";
    public static final String READER_FIELD_HEADER_CONFIG = "skip.headers";
    private static final String READER_FIELD_HEADER_DOC = "The number of rows to be skipped in the beginning of file.";
    public static final int READER_FIELD_HEADER_DEFAULT = 0;
    public static final String READER_FIELD_FOOTER_CONFIG = "skip.footers";
    private static final String READER_FIELD_FOOTER_DOC = "The number of rows to be skipped at the end of file.";
    public static final int READER_FIELD_FOOTER_DEFAULT = 0;
    public static final String READER_WAIT_MAX_MS_CONFIG = "read.max.wait.ms";
    private static final String READER_WAIT_MAX_MS_DOC = "Maximum time to wait in milliseconds for more bytes after hitting end of file.";
    public static final long READER_WAIT_MAX_MS__DEFAULT = 0L;

    RowFileInputReaderConfig(Map<String, ?> originals) {
        super(RowFileInputReaderConfig.configDef(), originals);
    }

    int bufferInitialBytesSize() {
        return this.getInt(BUFFER_INIT_BYTES_SIZE_CONFIG);
    }

    int minReadRecords() {
        return this.getInt(MIN_NUM_READ_RECORDS_CONFIG);
    }

    Charset charset() {
        return Charset.forName(this.getString(FILE_ENCODING_CONFIG));
    }

    int skipHeaders() {
        return this.getInt(READER_FIELD_HEADER_CONFIG);
    }

    int skipFooters() {
        return this.getInt(READER_FIELD_FOOTER_CONFIG);
    }

    long maxWaitMs() {
        return this.getLong(READER_WAIT_MAX_MS_CONFIG);
    }

    private static ConfigDef configDef() {
        return new ConfigDef().define(BUFFER_INIT_BYTES_SIZE_CONFIG, ConfigDef.Type.INT, (Object)4096, ConfigDef.Importance.MEDIUM, BUFFER_INIT_BYTES_SIZE_DOC).define(MIN_NUM_READ_RECORDS_CONFIG, ConfigDef.Type.INT, (Object)1, ConfigDef.Importance.MEDIUM, MIN_NUM_READ_RECORDS_DOC).define(FILE_ENCODING_CONFIG, ConfigDef.Type.STRING, (Object)FILE_ENCODING_DEFAULT, ConfigDef.Importance.HIGH, FILE_ENCODING_DOC).define(READER_FIELD_HEADER_CONFIG, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.HIGH, READER_FIELD_HEADER_DOC).define(READER_WAIT_MAX_MS_CONFIG, ConfigDef.Type.LONG, (Object)0L, ConfigDef.Importance.LOW, READER_WAIT_MAX_MS_DOC).define(READER_FIELD_FOOTER_CONFIG, ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.HIGH, READER_FIELD_FOOTER_DOC);
    }
}

