/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.reader.AbstractFileInputReader;
import io.streamthoughts.kafka.connect.filepulse.reader.BytesRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.reader.FileInputIterator;
import io.streamthoughts.kafka.connect.filepulse.reader.IteratorManager;
import io.streamthoughts.kafka.connect.filepulse.reader.RecordsIterable;
import io.streamthoughts.kafka.connect.filepulse.source.FileContext;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecord;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.source.SourceOffset;
import io.streamthoughts.kafka.connect.filepulse.source.TypedFileRecord;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileInputMetadataReader
extends AbstractFileInputReader {
    @Override
    protected FileInputIterator<FileRecord<TypedStruct>> newIterator(FileContext context, IteratorManager iteratorManager) {
        TypedFileRecord record = new TypedFileRecord((FileRecordOffset)BytesRecordOffset.empty(), TypedStruct.create((String)"kafka.connect.filepulse.FileMetadata").put("name", context.metadata().name()).put("path", context.metadata().path()).put("hash", Long.valueOf(context.metadata().hash())).put("lastModified", Long.valueOf(context.metadata().lastModified())).put("size", Long.valueOf(context.metadata().size())).put("inode", context.metadata().inode()));
        return new DelegatingFileInputIterator(context, Collections.singleton(record).iterator());
    }

    private static final class DelegatingFileInputIterator
    implements FileInputIterator<FileRecord<TypedStruct>> {
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private final Iterator<TypedFileRecord> iterator;
        private final FileContext context;

        DelegatingFileInputIterator(FileContext context, Iterator<TypedFileRecord> iterator) {
            this.context = context;
            this.iterator = iterator;
        }

        public FileContext context() {
            return this.context;
        }

        public void seekTo(SourceOffset offset) {
        }

        public RecordsIterable<FileRecord<TypedStruct>> next() {
            return RecordsIterable.of((Object[])new FileRecord[]{(FileRecord)this.iterator.next()});
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public void close() {
            this.isClosed.set(true);
        }

        public boolean isClose() {
            return this.isClosed.get();
        }
    }
}

