/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import io.streamthoughts.kafka.connect.filepulse.source.SourceOffset;
import io.streamthoughts.kafka.connect.filepulse.source.TimestampedRecordOffset;
import java.util.Objects;
import org.apache.kafka.common.utils.SystemTime;

public class BytesRecordOffset
extends TimestampedRecordOffset {
    private final long startPosition;
    private final long endPosition;

    public static BytesRecordOffset empty() {
        return new BytesRecordOffset(-1L, -1L, SystemTime.SYSTEM.milliseconds());
    }

    public static BytesRecordOffset with(long startPosition, long endPosition) {
        return new BytesRecordOffset(startPosition, endPosition, SystemTime.SYSTEM.milliseconds());
    }

    public BytesRecordOffset(long startPosition, long endPosition, long timestamp) {
        super(timestamp);
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public long startPosition() {
        return this.startPosition;
    }

    public long endPosition() {
        return this.endPosition;
    }

    public SourceOffset toSourceOffset() {
        return new SourceOffset(this.endPosition, -1L, this.timestamp());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BytesRecordOffset)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BytesRecordOffset that = (BytesRecordOffset)((Object)o);
        return this.startPosition == that.startPosition && this.endPosition == that.endPosition;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startPosition, this.endPosition);
    }

    public String toString() {
        return "[startPosition=" + this.startPosition + ", endPosition=" + this.endPosition + ", timestamp=" + this.timestamp() + ']';
    }
}

