/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.reader.AbstractFileInputIterator;
import io.streamthoughts.kafka.connect.filepulse.reader.AbstractFileInputReader;
import io.streamthoughts.kafka.connect.filepulse.reader.BytesRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.reader.FileInputIterator;
import io.streamthoughts.kafka.connect.filepulse.reader.IteratorManager;
import io.streamthoughts.kafka.connect.filepulse.reader.ReaderException;
import io.streamthoughts.kafka.connect.filepulse.reader.RecordsIterable;
import io.streamthoughts.kafka.connect.filepulse.source.FileContext;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecord;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecordOffset;
import io.streamthoughts.kafka.connect.filepulse.source.SourceOffset;
import io.streamthoughts.kafka.connect.filepulse.source.TypedFileRecord;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NoSuchElementException;

public class BytesArrayInputReader
extends AbstractFileInputReader {
    @Override
    protected FileInputIterator<FileRecord<TypedStruct>> newIterator(FileContext context, IteratorManager iteratorManager) {
        return new BytesArrayInputIterator(context, iteratorManager);
    }

    public static class BytesArrayInputIterator
    extends AbstractFileInputIterator<TypedStruct> {
        private boolean hasNext = true;

        BytesArrayInputIterator(FileContext context, IteratorManager iteratorManager) {
            super(iteratorManager, context);
        }

        public void seekTo(SourceOffset offset) {
        }

        public RecordsIterable<FileRecord<TypedStruct>> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                File file = this.context().file();
                Path path = file.toPath();
                byte[] bytes = Files.readAllBytes(path);
                TypedStruct struct = TypedStruct.create();
                struct.put("message", bytes);
                BytesRecordOffset offset = BytesRecordOffset.with(0L, bytes.length);
                RecordsIterable recordsIterable = RecordsIterable.of((Object[])new FileRecord[]{new TypedFileRecord((FileRecordOffset)offset, struct)});
                return recordsIterable;
            }
            catch (IOException e) {
                throw new ReaderException("Error while reading file :  " + this.context().metadata(), (Throwable)e);
            }
            finally {
                this.hasNext = false;
            }
        }

        public boolean hasNext() {
            return !this.isClose() && this.hasNext;
        }
    }
}

