/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import io.streamthoughts.kafka.connect.filepulse.source.SourceOffset;
import io.streamthoughts.kafka.connect.filepulse.source.TimestampedRecordOffset;
import java.util.Objects;
import org.apache.kafka.common.utils.Time;

public class AvroRecordOffset
extends TimestampedRecordOffset {
    private final long blockStart;
    private final long position;
    private final long records;

    protected AvroRecordOffset(long blockStart, long position, long records) {
        this(blockStart, position, records, Time.SYSTEM.milliseconds());
    }

    private AvroRecordOffset(long blockStart, long position, long records, long timestamp) {
        super(timestamp);
        this.blockStart = blockStart;
        this.position = position;
        this.records = records;
    }

    public long blockStart() {
        return this.blockStart;
    }

    public long position() {
        return this.position;
    }

    public long records() {
        return this.records;
    }

    public SourceOffset toSourceOffset() {
        return new SourceOffset(this.blockStart, this.records, this.timestamp());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvroRecordOffset)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AvroRecordOffset that = (AvroRecordOffset)((Object)o);
        return this.blockStart == that.blockStart && this.position == that.position && this.records == that.records;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.blockStart, this.position, this.records);
    }

    public String toString() {
        return "[blockStart=" + this.blockStart + ", position=" + this.position + ", records=" + this.records + ", timestamp=" + this.timestamp() + "]";
    }
}

