/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.reader;

import io.streamthoughts.kafka.connect.filepulse.reader.FileInputIterator;
import io.streamthoughts.kafka.connect.filepulse.reader.IteratorManager;
import io.streamthoughts.kafka.connect.filepulse.source.FileContext;
import io.streamthoughts.kafka.connect.filepulse.source.FileRecord;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractFileInputIterator<T>
implements FileInputIterator<FileRecord<T>> {
    private final AtomicBoolean closed;
    private final IteratorManager iteratorManager;
    protected FileContext context;

    public AbstractFileInputIterator(IteratorManager iteratorManager, FileContext context) {
        Objects.requireNonNull(iteratorManager, "iteratorManager can't be null");
        Objects.requireNonNull(context, "context can't be null");
        this.iteratorManager = iteratorManager;
        this.context = context;
        this.closed = new AtomicBoolean(false);
    }

    public FileContext context() {
        return this.context;
    }

    public void close() {
        if (!this.isClose()) {
            this.iteratorManager.removeIterator(this);
            this.closed.set(true);
        }
    }

    public boolean isClose() {
        return this.closed.get();
    }
}

