/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.offset;

import io.streamthoughts.kafka.connect.filepulse.errors.ConnectFilePulseException;
import io.streamthoughts.kafka.connect.filepulse.offset.OffsetManager;
import io.streamthoughts.kafka.connect.filepulse.offset.OffsetStrategy;
import io.streamthoughts.kafka.connect.filepulse.source.SourceMetadata;
import io.streamthoughts.kafka.connect.filepulse.source.SourceOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.source.SourceTaskContext;

public class SimpleOffsetManager
implements OffsetManager {
    private static final String POSITION_OFFSET_FIELD = "position";
    private static final String POSITION_ROWS_FIELD = "rows";
    private static final String POSITION_TIMESTAMP_FIELD = "timestamp";
    private final OffsetStrategy strategy;

    public SimpleOffsetManager(OffsetStrategy strategy) {
        Objects.requireNonNull(strategy, "strategy can't be null");
        this.strategy = strategy;
    }

    public Optional<SourceOffset> getOffsetFor(SourceTaskContext context, SourceMetadata metadata) {
        Object timestamp;
        Map<String, Object> partition = this.toPartitionMap(metadata);
        Map offset = context.offsetStorageReader().offset(partition);
        Object offsetBytes = offset != null ? offset.get(POSITION_OFFSET_FIELD) : null;
        Object rows = offset != null ? offset.get(POSITION_ROWS_FIELD) : null;
        Object v0 = timestamp = offset != null ? offset.get(POSITION_TIMESTAMP_FIELD) : null;
        if (offsetBytes == null || rows == null || timestamp == null) {
            return Optional.empty();
        }
        this.checkOffsetIsValid(offsetBytes);
        this.checkRowsIsValid(rows);
        this.checkTimestampIsValid(timestamp);
        return Optional.of(new SourceOffset(((Long)offsetBytes).longValue(), ((Long)rows).longValue(), ((Long)timestamp).longValue()));
    }

    private void checkTimestampIsValid(Object timestamp) {
        if (!(timestamp instanceof Long)) {
            throw new ConnectFilePulseException("Incorrect type for the last active timestamp");
        }
    }

    private void checkRowsIsValid(Object rows) {
        if (!(rows instanceof Long)) {
            throw new ConnectFilePulseException("Incorrect type for number of rows");
        }
    }

    private void checkOffsetIsValid(Object offsetBytes) {
        if (!(offsetBytes instanceof Long)) {
            throw new ConnectFilePulseException("Incorrect type for position bytes");
        }
    }

    public Map<String, Object> toPartitionMap(SourceMetadata metadata) {
        return this.strategy.toPartitionMap(metadata);
    }

    public Map<String, ?> toOffsetMap(SourceOffset offset) {
        Objects.requireNonNull(offset, "position can't be null");
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(POSITION_OFFSET_FIELD, offset.position());
        map.put(POSITION_ROWS_FIELD, offset.rows());
        map.put(POSITION_TIMESTAMP_FIELD, offset.timestamp());
        return map;
    }
}

