/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.offset;

import io.streamthoughts.kafka.connect.filepulse.errors.ConnectFilePulseException;
import io.streamthoughts.kafka.connect.filepulse.offset.OffsetStrategy;
import io.streamthoughts.kafka.connect.filepulse.source.SourceMetadata;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class ComposeOffsetStrategy
implements OffsetStrategy {
    private static final String FILEPATH_FIELD = "path";
    private static final String FILENAME_FIELD = "name";
    private static final String INODE_FIELD = "inode";
    private static final String CRC32_FIELD = "hash";
    private static final String MODIFIED_FIELD = "lastmodified";
    private static final Map<String, GenericOffsetStrategy> STRATEGIES = new HashMap<String, GenericOffsetStrategy>();
    private final String offsetStrategyString;
    private final List<GenericOffsetStrategy> strategies;

    public ComposeOffsetStrategy(String offsetStrategyString) {
        this.offsetStrategyString = Objects.requireNonNull(offsetStrategyString);
        this.strategies = new ArrayList<GenericOffsetStrategy>();
        for (String label : offsetStrategyString.split("\\+")) {
            GenericOffsetStrategy strategy = STRATEGIES.get(label.toLowerCase());
            if (strategy == null) {
                throw new IllegalArgumentException("Unknown offset strategy for name '" + label + "'");
            }
            this.strategies.add(strategy);
        }
        this.strategies.sort(Comparator.comparingInt(o -> o.priority));
        if (this.strategies.isEmpty()) {
            throw new IllegalArgumentException("Cannot build empty 'offset.strategy'");
        }
    }

    @Override
    public Map<String, Object> toPartitionMap(SourceMetadata metadata) {
        LinkedHashMap<String, Object> offset = new LinkedHashMap<String, Object>();
        for (GenericOffsetStrategy strategy : this.strategies) {
            strategy.addAttributeToPartitionMap(metadata, offset);
        }
        return offset;
    }

    public String toString() {
        return "OffsetStrategy[" + this.offsetStrategyString + "]";
    }

    static {
        STRATEGIES.put(FILENAME_FIELD, new GenericOffsetStrategy(FILENAME_FIELD, 1, SourceMetadata::name));
        STRATEGIES.put(FILEPATH_FIELD, new GenericOffsetStrategy(FILEPATH_FIELD, 2, SourceMetadata::path));
        STRATEGIES.put(CRC32_FIELD, new GenericOffsetStrategy(CRC32_FIELD, 3, SourceMetadata::hash));
        STRATEGIES.put(MODIFIED_FIELD, new GenericOffsetStrategy(MODIFIED_FIELD, 4, SourceMetadata::lastModified));
        STRATEGIES.put(INODE_FIELD, new GenericOffsetStrategy(INODE_FIELD, 5, metadata -> {
            if (metadata.inode() == null) {
                throw new ConnectFilePulseException("Unix-inode is not supported. Consider configuring a different 'offset-strategy' (i.e: path, name, hash, name+hash)");
            }
            return metadata.inode();
        }));
    }

    private static class GenericOffsetStrategy {
        final String name;
        final Function<SourceMetadata, Object> offsetFunction;
        final int priority;

        GenericOffsetStrategy(String name, int priority, Function<SourceMetadata, Object> offsetFunction) {
            this.name = Objects.requireNonNull(name, "name cannot be null");
            this.offsetFunction = Objects.requireNonNull(offsetFunction, "offsetFunction cannot be null");
            this.priority = priority;
        }

        void addAttributeToPartitionMap(SourceMetadata metadata, Map<String, Object> offset) {
            offset.put(this.name, this.offsetFunction.apply(metadata));
        }
    }
}

