/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.config;

import io.streamthoughts.kafka.connect.filepulse.config.CommonConfig;
import io.streamthoughts.kafka.connect.filepulse.filter.RecordFilter;
import io.streamthoughts.kafka.connect.filepulse.reader.FileInputReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.errors.ConnectException;

public class TaskConfig
extends CommonConfig {
    public static final String FILE_INPUT_PATHS_CONFIG = "file.input.paths";
    private static final String FILE_INPUT_PATHS_DOC = "The list of files task must proceed.";
    private static final String OMIT_READ_COMMITTED_FILE_CONFIG = "ignore.committed.offsets";
    private static final String OMIT_READ_COMMITTED_FILE_DOC = "Boolean indicating whether offsets check has to be performed, to avoid multiple (default : false)";
    public static final String INTERNAL_REPORTER_GROUP_ID = "internal.kafka.reporter.id";
    private static final String INTERNAL_REPORTER_GROUP_ID_DOC = "Reporter identifier to be used by tasks and connector to report and monitor file progression";
    private final EnrichedConnectorConfig enrichedConfig;

    static ConfigDef getConf() {
        return CommonConfig.getConf().define(INTERNAL_REPORTER_GROUP_ID, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, INTERNAL_REPORTER_GROUP_ID_DOC).define(FILE_INPUT_PATHS_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, FILE_INPUT_PATHS_DOC).define(OMIT_READ_COMMITTED_FILE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, OMIT_READ_COMMITTED_FILE_DOC);
    }

    public TaskConfig(Map<String, String> originals) {
        this(TaskConfig.getConf(), originals);
    }

    private TaskConfig(ConfigDef configDef, Map<String, String> originals) {
        super(TaskConfig.getConf(), originals);
        this.enrichedConfig = new EnrichedConnectorConfig(TaskConfig.enrich(configDef, originals), originals);
    }

    public Object get(String key) {
        return this.enrichedConfig.get(key);
    }

    private static ConfigDef enrich(ConfigDef baseConfigDef, Map<String, String> props) {
        Object filterAliases = ConfigDef.parseType((String)"filters", (Object)props.get("filters"), (ConfigDef.Type)ConfigDef.Type.LIST);
        if (!(filterAliases instanceof List)) {
            return baseConfigDef;
        }
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        LinkedHashSet uniqueFilterAliases = new LinkedHashSet((List)filterAliases);
        for (Object o : uniqueFilterAliases) {
            ConfigDef filterConfigDef;
            if (!(o instanceof String)) {
                throw new ConfigException("Item in " + filterAliases + " property is not of type string");
            }
            String alias = (String)o;
            String prefix = "filters." + alias + ".";
            String group = "Filters: " + alias;
            int orderInGroup = 0;
            String filterTypeConfig = prefix + "type";
            ConfigDef.Validator typeValidator = (name, value) -> TaskConfig.getConfigDefFromFilter(filterTypeConfig, (Class)value);
            newDef.define(filterTypeConfig, ConfigDef.Type.CLASS, ConfigDef.NO_DEFAULT_VALUE, typeValidator, ConfigDef.Importance.HIGH, "Class for the '" + alias + "' filter.", group, orderInGroup++, ConfigDef.Width.LONG, "Filter type for " + alias);
            try {
                String className = props.get(filterTypeConfig);
                Class cls = (Class)ConfigDef.parseType((String)filterTypeConfig, (Object)className, (ConfigDef.Type)ConfigDef.Type.CLASS);
                filterConfigDef = TaskConfig.getConfigDefFromFilter(filterTypeConfig, cls);
            }
            catch (ConfigException e) {
                continue;
            }
            newDef.embed(prefix, group, orderInGroup, filterConfigDef);
        }
        return newDef;
    }

    public String getTasksReporterGroupId() {
        return this.getString(INTERNAL_REPORTER_GROUP_ID);
    }

    public List<String> files() {
        return this.getList(FILE_INPUT_PATHS_CONFIG);
    }

    public boolean isReadCommittedFile() {
        return this.getBoolean(OMIT_READ_COMMITTED_FILE_CONFIG);
    }

    public String topic() {
        return this.getString("topic");
    }

    public FileInputReader reader() {
        return (FileInputReader)this.getConfiguredInstance("task.reader.class", FileInputReader.class);
    }

    public List<RecordFilter> filters() {
        List filterAliases = this.getList("filters");
        ArrayList<RecordFilter> filters = new ArrayList<RecordFilter>(filterAliases.size());
        for (String alias : filterAliases) {
            String prefix = "filters." + alias + ".";
            try {
                RecordFilter filter = this.getClass(prefix + "type").asSubclass(RecordFilter.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                filter.configure(this.originalsWithPrefix(prefix));
                filters.add(filter);
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e);
            }
        }
        return filters;
    }

    private static ConfigDef getConfigDefFromFilter(String key, Class<?> filterClass) {
        RecordFilter filter;
        if (filterClass == null || !RecordFilter.class.isAssignableFrom(filterClass)) {
            throw new ConfigException(key, (Object)String.valueOf(filterClass), "Not a RecordFilter");
        }
        try {
            filter = filterClass.asSubclass(RecordFilter.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConfigException(key, (Object)String.valueOf(filterClass), "Error getting configDef definition from RecordFilter: " + e.getMessage());
        }
        ConfigDef configDef = filter.configDef();
        if (null == configDef) {
            throw new ConnectException(String.format("%s.configDef() must return a ConfigDef that is not null.", filterClass.getName()));
        }
        return configDef;
    }

    private static class EnrichedConnectorConfig
    extends AbstractConfig {
        EnrichedConnectorConfig(ConfigDef configDef, Map<String, String> props) {
            super(configDef, props);
        }

        public Object get(String key) {
            return super.get(key);
        }
    }
}

