/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.config;

import io.streamthoughts.kafka.connect.filepulse.offset.ComposeOffsetStrategy;
import io.streamthoughts.kafka.connect.filepulse.offset.OffsetStrategy;
import io.streamthoughts.kafka.connect.filepulse.reader.RowFileInputReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class CommonConfig
extends AbstractConfig {
    public static final String OUTPUT_TOPIC_CONFIG = "topic";
    private static final String OUTPUT_TOPIC_DOC = "The Kafka topic to write the value to.";
    public static final String FILE_READER_CLASS_CONFIG = "task.reader.class";
    private static final String FILE_READER_CLASS_CONFIG_DOC = "Class which is used by tasks to read an input file.";
    public static final String OFFSET_STRATEGY_CONFIG = "offset.strategy";
    private static final String OFFSET_STRATEGY_DOC = "A separated list of attributes, using '+' character as separator, to be used for uniquely identifying an input file; must be one of [name, path, lastModified, inode, hash] (e.g: name+hash). Note that order doesn't matter.";
    private static final String OFFSET_STRATEGY_DEFAULT = "path+name";
    public static final String FILTERS_GROUP = "Filters";
    public static final String FILTER_CONFIG = "filters";
    private static final String FILTER_DOC = "List of filters aliases to apply on each value (order is important).";
    public static final String TASKS_REPORTER_TOPIC = "internal.kafka.reporter.topic";
    private static final String TASKS_REPORTER_TOPIC_DOC = "Topic name which is used to report file states.";
    private static final String TASKS_REPORTER_TOPIC_DEFAULT = "connect-file-pulse-status";
    public static final String INTERNAL_REPORTER_CLUSTER_BOOTSTRAP_SERVER = "internal.kafka.reporter.bootstrap.servers";

    CommonConfig(ConfigDef definition, Map<?, ?> originals) {
        super(definition, originals, false);
    }

    static ConfigDef getConf() {
        return new ConfigDef().define(FILE_READER_CLASS_CONFIG, ConfigDef.Type.CLASS, RowFileInputReader.class, ConfigDef.Importance.HIGH, FILE_READER_CLASS_CONFIG_DOC).define(OUTPUT_TOPIC_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, OUTPUT_TOPIC_DOC).define(OFFSET_STRATEGY_CONFIG, ConfigDef.Type.STRING, (Object)OFFSET_STRATEGY_DEFAULT, ConfigDef.Importance.HIGH, OFFSET_STRATEGY_DOC).define(FILTER_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.HIGH, FILTER_DOC, FILTERS_GROUP, -1, ConfigDef.Width.NONE, FILTER_CONFIG).define(TASKS_REPORTER_TOPIC, ConfigDef.Type.STRING, (Object)TASKS_REPORTER_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, TASKS_REPORTER_TOPIC_DOC).define(INTERNAL_REPORTER_CLUSTER_BOOTSTRAP_SERVER, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).");
    }

    public OffsetStrategy offsetStrategy() {
        return new ComposeOffsetStrategy(this.getString(OFFSET_STRATEGY_CONFIG));
    }

    public String getTaskReporterTopic() {
        return this.getString(TASKS_REPORTER_TOPIC);
    }

    public String getInternalBootstrapServers() {
        return this.getString(INTERNAL_REPORTER_CLUSTER_BOOTSTRAP_SERVER);
    }

    public Map<String, Object> getInternalKafkaConsumerConfigs() {
        return this.originalsWithPrefix("internal.kafka.reporter.consumer.");
    }

    public Map<String, Object> getInternalKafkaProducerConfigs() {
        return this.originalsWithPrefix("internal.kafka.reporter.producer.");
    }

    public Map<String, Object> getInternalKafkaReporterConfig() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", this.getInternalBootstrapServers());
        configs.putAll(this.getInternalKafkaConsumerConfigs());
        configs.putAll(this.getInternalKafkaProducerConfigs());
        return configs;
    }
}

