/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.clean;

import io.streamthoughts.kafka.connect.filepulse.clean.FileCleanupPolicy;
import io.streamthoughts.kafka.connect.filepulse.internal.IOUtils;
import io.streamthoughts.kafka.connect.filepulse.source.SourceFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveCleanupPolicy
implements FileCleanupPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MoveCleanupPolicy.class);
    private MoveFileCleanerConfig configs;

    public void configure(Map<String, ?> configs) {
        this.configs = new MoveFileCleanerConfig(configs);
    }

    public boolean onSuccess(SourceFile source) {
        File file = source.file();
        if (!file.exists()) {
            LOG.warn("Cannot move file '{}' to success path due to file does not exist.", (Object)file);
            return true;
        }
        return this.doCleanup(file, MoveCleanupPolicy.buildTargetPath(this.configs.scanDirectoryPath(), file, this.configs.outputSucceedPath()));
    }

    public boolean onFailure(SourceFile source) {
        File file = source.file();
        if (!file.exists()) {
            LOG.warn("Cannot move file '{}' to error path due to file does not exist.", (Object)file);
            return true;
        }
        return this.doCleanup(file, MoveCleanupPolicy.buildTargetPath(this.configs.scanDirectoryPath(), file, this.configs.outputFailedPath()));
    }

    private static Path buildTargetPath(String scannedDirectory, File source, String target) {
        String name = source.getName();
        if (IOUtils.isAbsolute((String)target)) {
            String relative = IOUtils.getRelativePathFrom((String)scannedDirectory, (File)source);
            return Paths.get(target, relative, name);
        }
        String parent = source.getParentFile().getAbsolutePath();
        return Paths.get(parent, target, name);
    }

    private boolean doCleanup(File source, Path target) {
        Path sourcePath = source.toPath();
        try {
            LOG.info("Moving file {} to {}", (Object)source, (Object)target.toFile());
            IOUtils.createParentIfNotExists((Path)target);
            Files.move(sourcePath, target, StandardCopyOption.ATOMIC_MOVE);
            LOG.info("File {} moved successfully", (Object)source);
        }
        catch (IOException outer) {
            try {
                Files.move(sourcePath, target, StandardCopyOption.REPLACE_EXISTING);
                LOG.debug("Non-atomic move of {} to {} succeeded after atomic move failed due to {}", new Object[]{source, target, outer.getMessage()});
            }
            catch (IOException inner) {
                inner.addSuppressed(outer);
                LOG.error("Error while moving file {}", (Object)source, (Object)inner);
                return false;
            }
        }
        return true;
    }

    public void close() throws Exception {
    }

    public static class MoveFileCleanerConfig
    extends AbstractConfig {
        static final String CLEANER_OUTPUT_FAILED_PATH_CONFIG = "cleaner.output.failed.path";
        static final String CLEANER_OUTPUT_FAILED_PATH_DOC = "Target directory for file proceed with failure (default .failure)";
        static final String CLEANER_OUTPUT_SUCCEED_PATH_CONFIG = "cleaner.output.succeed.path";
        static final String CLEANER_OUTPUT_SUCCEED_PATH_DOC = "Target directory for file proceed successfully (default .success)";

        MoveFileCleanerConfig(Map<?, ?> originals) {
            super(MoveFileCleanerConfig.getConf(), originals);
        }

        String outputFailedPath() {
            return this.getString(CLEANER_OUTPUT_FAILED_PATH_CONFIG);
        }

        String outputSucceedPath() {
            return this.getString(CLEANER_OUTPUT_SUCCEED_PATH_CONFIG);
        }

        String scanDirectoryPath() {
            return this.getString("fs.scan.directory.path");
        }

        static ConfigDef getConf() {
            return new ConfigDef().define(CLEANER_OUTPUT_FAILED_PATH_CONFIG, ConfigDef.Type.STRING, (Object)".failure", ConfigDef.Importance.HIGH, CLEANER_OUTPUT_FAILED_PATH_DOC).define(CLEANER_OUTPUT_SUCCEED_PATH_CONFIG, ConfigDef.Type.STRING, (Object)".success", ConfigDef.Importance.HIGH, CLEANER_OUTPUT_SUCCEED_PATH_DOC).define("fs.scan.directory.path", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "The input directory to scan");
        }
    }
}

