/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.clean;

import io.streamthoughts.kafka.connect.filepulse.clean.FileCleanupPolicy;
import io.streamthoughts.kafka.connect.filepulse.source.SourceFile;
import io.streamthoughts.kafka.connect.filepulse.source.SourceMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCleanupPolicy
implements FileCleanupPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteCleanupPolicy.class);

    public void configure(Map<String, ?> configs) {
    }

    public boolean onSuccess(SourceFile source) {
        SourceMetadata metadata = source.metadata();
        return this.doCleanup(new File(metadata.absolutePath()));
    }

    public boolean onFailure(SourceFile source) {
        SourceMetadata metadata = source.metadata();
        return this.doCleanup(new File(metadata.absolutePath()));
    }

    private boolean doCleanup(File file) {
        try {
            Files.deleteIfExists(file.toPath());
            LOG.debug("Finished to cleanup input file successfully : {}", (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.error("Error while removing file {}", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
        return true;
    }

    public void close() throws Exception {
    }
}

