/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.kubernetes;

import com.google.gson.Gson;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1Toleration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesManifestCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicKubernetesManifestCustomizer
implements KubernetesManifestCustomizer {
    private static final Logger log = LoggerFactory.getLogger(BasicKubernetesManifestCustomizer.class);
    private static final String RESOURCE_CPU = "cpu";
    private static final String RESOURCE_MEMORY = "memory";
    private static final String[] RESOURCES = new String[]{"cpu", "memory"};
    private RuntimeOpts runtimeOpts = new RuntimeOpts();

    @Override
    public void initialize(Map<String, Object> config) {
        if (config != null) {
            RuntimeOpts opts = (RuntimeOpts)ObjectMapperFactory.getThreadLocal().convertValue(config, RuntimeOpts.class);
            if (opts != null) {
                this.runtimeOpts = opts;
            }
        } else {
            log.warn("initialize with null config");
        }
    }

    @Override
    public String customizeNamespace(Function.FunctionDetails funcDetails, String currentNamespace) {
        RuntimeOpts opts = this.getOptsFromDetails(funcDetails);
        if (!StringUtils.isEmpty((CharSequence)(opts = BasicKubernetesManifestCustomizer.mergeRuntimeOpts(this.runtimeOpts, opts)).getJobNamespace())) {
            return opts.getJobNamespace();
        }
        return currentNamespace;
    }

    @Override
    public String customizeName(Function.FunctionDetails funcDetails, String currentName) {
        RuntimeOpts opts = this.getOptsFromDetails(funcDetails);
        if (!StringUtils.isEmpty((CharSequence)(opts = BasicKubernetesManifestCustomizer.mergeRuntimeOpts(this.runtimeOpts, opts)).getJobName())) {
            return opts.getJobName();
        }
        return currentName;
    }

    @Override
    public V1Service customizeService(Function.FunctionDetails funcDetails, V1Service service) {
        RuntimeOpts opts = this.getOptsFromDetails(funcDetails);
        opts = BasicKubernetesManifestCustomizer.mergeRuntimeOpts(this.runtimeOpts, opts);
        service.setMetadata(this.updateMeta(opts, service.getMetadata()));
        return service;
    }

    @Override
    public V1StatefulSet customizeStatefulSet(Function.FunctionDetails funcDetails, V1StatefulSet statefulSet) {
        RuntimeOpts opts = BasicKubernetesManifestCustomizer.mergeRuntimeOpts(this.runtimeOpts, this.getOptsFromDetails(funcDetails));
        statefulSet.setMetadata(this.updateMeta(opts, statefulSet.getMetadata()));
        V1PodTemplateSpec pt = statefulSet.getSpec().getTemplate();
        pt.setMetadata(this.updateMeta(opts, pt.getMetadata()));
        V1PodSpec ps = pt.getSpec();
        if (ps != null) {
            if (opts.getNodeSelectorLabels() != null && opts.getNodeSelectorLabels().size() > 0) {
                opts.getNodeSelectorLabels().forEach((arg_0, arg_1) -> ((V1PodSpec)ps).putNodeSelectorItem(arg_0, arg_1));
            }
            if (opts.getTolerations() != null && opts.getTolerations().size() > 0) {
                opts.getTolerations().forEach(arg_0 -> ((V1PodSpec)ps).addTolerationsItem(arg_0));
            }
            ps.getContainers().forEach(container -> this.updateContainerResources((V1Container)container, opts));
        }
        return statefulSet;
    }

    private void updateContainerResources(V1Container container, RuntimeOpts opts) {
        if (opts.getResourceRequirements() != null) {
            V1ResourceRequirements resourceRequirements = opts.getResourceRequirements();
            V1ResourceRequirements containerResources = container.getResources();
            Map limits = resourceRequirements.getLimits();
            Map requests = resourceRequirements.getRequests();
            for (String resource : RESOURCES) {
                if (limits != null && limits.containsKey(resource)) {
                    containerResources.putLimitsItem(resource, (Quantity)limits.get(resource));
                }
                if (requests == null || !requests.containsKey(resource)) continue;
                containerResources.putRequestsItem(resource, (Quantity)requests.get(resource));
            }
        }
    }

    private RuntimeOpts getOptsFromDetails(Function.FunctionDetails funcDetails) {
        String customRuntimeOptions = funcDetails.getCustomRuntimeOptions();
        RuntimeOpts opts = (RuntimeOpts)new Gson().fromJson(customRuntimeOptions, RuntimeOpts.class);
        if (opts == null) {
            opts = new RuntimeOpts();
        }
        return opts;
    }

    private V1ObjectMeta updateMeta(RuntimeOpts opts, V1ObjectMeta meta) {
        if (opts.getExtraAnnotations() != null && opts.getExtraAnnotations().size() > 0) {
            opts.getExtraAnnotations().forEach((arg_0, arg_1) -> ((V1ObjectMeta)meta).putAnnotationsItem(arg_0, arg_1));
        }
        if (opts.getExtraLabels() != null && opts.getExtraLabels().size() > 0) {
            opts.getExtraLabels().forEach((arg_0, arg_1) -> ((V1ObjectMeta)meta).putLabelsItem(arg_0, arg_1));
        }
        return meta;
    }

    public static RuntimeOpts mergeRuntimeOpts(RuntimeOpts oriOpts, RuntimeOpts newOpts) {
        RuntimeOpts mergedOpts = oriOpts.partialDeepClone();
        if (mergedOpts.getExtraLabels() == null) {
            mergedOpts.setExtraLabels(new HashMap<String, String>());
        }
        if (mergedOpts.getExtraAnnotations() == null) {
            mergedOpts.setExtraAnnotations(new HashMap<String, String>());
        }
        if (mergedOpts.getNodeSelectorLabels() == null) {
            mergedOpts.setNodeSelectorLabels(new HashMap<String, String>());
        }
        if (mergedOpts.getTolerations() == null) {
            mergedOpts.setTolerations(new ArrayList<V1Toleration>());
        }
        if (mergedOpts.getResourceRequirements() == null) {
            mergedOpts.setResourceRequirements(new V1ResourceRequirements());
        }
        if (!StringUtils.isEmpty((CharSequence)newOpts.getJobName())) {
            mergedOpts.setJobName(newOpts.getJobName());
        }
        if (!StringUtils.isEmpty((CharSequence)newOpts.getJobNamespace())) {
            mergedOpts.setJobNamespace(newOpts.getJobNamespace());
        }
        if (newOpts.getExtraLabels() != null && !newOpts.getExtraLabels().isEmpty()) {
            newOpts.getExtraLabels().forEach((key, labelsItem) -> {
                if (!mergedOpts.getExtraLabels().containsKey(key)) {
                    log.debug("extra label {} has been changed to {}", key, labelsItem);
                }
                mergedOpts.getExtraLabels().put((String)key, (String)labelsItem);
            });
        }
        if (newOpts.getExtraAnnotations() != null && !newOpts.getExtraAnnotations().isEmpty()) {
            newOpts.getExtraAnnotations().forEach((key, annotationsItem) -> {
                if (!mergedOpts.getExtraAnnotations().containsKey(key)) {
                    log.debug("extra annotation {} has been changed to {}", key, annotationsItem);
                }
                mergedOpts.getExtraAnnotations().put((String)key, (String)annotationsItem);
            });
        }
        if (newOpts.getNodeSelectorLabels() != null && !newOpts.getNodeSelectorLabels().isEmpty()) {
            newOpts.getNodeSelectorLabels().forEach((key, nodeSelectorItem) -> {
                if (!mergedOpts.getNodeSelectorLabels().containsKey(key)) {
                    log.debug("node selector label {} has been changed to {}", key, nodeSelectorItem);
                }
                mergedOpts.getNodeSelectorLabels().put((String)key, (String)nodeSelectorItem);
            });
        }
        if (newOpts.getResourceRequirements() != null) {
            V1ResourceRequirements mergedResourcesRequirements = mergedOpts.getResourceRequirements();
            V1ResourceRequirements newResourcesRequirements = newOpts.getResourceRequirements();
            Map limits = newResourcesRequirements.getLimits();
            Map requests = newResourcesRequirements.getRequests();
            for (String resource : RESOURCES) {
                if (limits != null && limits.containsKey(resource)) {
                    mergedResourcesRequirements.putLimitsItem(resource, (Quantity)limits.get(resource));
                }
                if (requests == null || !requests.containsKey(resource)) continue;
                mergedResourcesRequirements.putRequestsItem(resource, (Quantity)requests.get(resource));
            }
            mergedOpts.setResourceRequirements(mergedResourcesRequirements);
        }
        if (newOpts.getTolerations() != null && !newOpts.getTolerations().isEmpty()) {
            mergedOpts.getTolerations().addAll(newOpts.getTolerations());
        }
        return mergedOpts;
    }

    public RuntimeOpts getRuntimeOpts() {
        return this.runtimeOpts;
    }

    public static class RuntimeOpts {
        private String jobNamespace;
        private String jobName;
        private Map<String, String> extraLabels;
        private Map<String, String> extraAnnotations;
        private Map<String, String> nodeSelectorLabels;
        private V1ResourceRequirements resourceRequirements;
        private List<V1Toleration> tolerations;

        public RuntimeOpts partialDeepClone() {
            return new RuntimeOpts(this.jobNamespace, this.jobName, this.extraLabels != null ? new HashMap<String, String>(this.extraLabels) : null, this.extraAnnotations != null ? new HashMap<String, String>(this.extraAnnotations) : null, this.nodeSelectorLabels != null ? new HashMap<String, String>(this.nodeSelectorLabels) : null, this.resourceRequirements, (List<V1Toleration>)(this.tolerations != null ? new ArrayList<V1Toleration>(this.tolerations) : null));
        }

        public static RuntimeOptsBuilder builder() {
            return new RuntimeOptsBuilder();
        }

        public String getJobNamespace() {
            return this.jobNamespace;
        }

        public String getJobName() {
            return this.jobName;
        }

        public Map<String, String> getExtraLabels() {
            return this.extraLabels;
        }

        public Map<String, String> getExtraAnnotations() {
            return this.extraAnnotations;
        }

        public Map<String, String> getNodeSelectorLabels() {
            return this.nodeSelectorLabels;
        }

        public V1ResourceRequirements getResourceRequirements() {
            return this.resourceRequirements;
        }

        public List<V1Toleration> getTolerations() {
            return this.tolerations;
        }

        public void setJobNamespace(String jobNamespace) {
            this.jobNamespace = jobNamespace;
        }

        public void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public void setExtraLabels(Map<String, String> extraLabels) {
            this.extraLabels = extraLabels;
        }

        public void setExtraAnnotations(Map<String, String> extraAnnotations) {
            this.extraAnnotations = extraAnnotations;
        }

        public void setNodeSelectorLabels(Map<String, String> nodeSelectorLabels) {
            this.nodeSelectorLabels = nodeSelectorLabels;
        }

        public void setResourceRequirements(V1ResourceRequirements resourceRequirements) {
            this.resourceRequirements = resourceRequirements;
        }

        public void setTolerations(List<V1Toleration> tolerations) {
            this.tolerations = tolerations;
        }

        public RuntimeOpts() {
        }

        public RuntimeOpts(String jobNamespace, String jobName, Map<String, String> extraLabels, Map<String, String> extraAnnotations, Map<String, String> nodeSelectorLabels, V1ResourceRequirements resourceRequirements, List<V1Toleration> tolerations) {
            this.jobNamespace = jobNamespace;
            this.jobName = jobName;
            this.extraLabels = extraLabels;
            this.extraAnnotations = extraAnnotations;
            this.nodeSelectorLabels = nodeSelectorLabels;
            this.resourceRequirements = resourceRequirements;
            this.tolerations = tolerations;
        }

        public static class RuntimeOptsBuilder {
            private String jobNamespace;
            private String jobName;
            private Map<String, String> extraLabels;
            private Map<String, String> extraAnnotations;
            private Map<String, String> nodeSelectorLabels;
            private V1ResourceRequirements resourceRequirements;
            private List<V1Toleration> tolerations;

            RuntimeOptsBuilder() {
            }

            public RuntimeOptsBuilder jobNamespace(String jobNamespace) {
                this.jobNamespace = jobNamespace;
                return this;
            }

            public RuntimeOptsBuilder jobName(String jobName) {
                this.jobName = jobName;
                return this;
            }

            public RuntimeOptsBuilder extraLabels(Map<String, String> extraLabels) {
                this.extraLabels = extraLabels;
                return this;
            }

            public RuntimeOptsBuilder extraAnnotations(Map<String, String> extraAnnotations) {
                this.extraAnnotations = extraAnnotations;
                return this;
            }

            public RuntimeOptsBuilder nodeSelectorLabels(Map<String, String> nodeSelectorLabels) {
                this.nodeSelectorLabels = nodeSelectorLabels;
                return this;
            }

            public RuntimeOptsBuilder resourceRequirements(V1ResourceRequirements resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public RuntimeOptsBuilder tolerations(List<V1Toleration> tolerations) {
                this.tolerations = tolerations;
                return this;
            }

            public RuntimeOpts build() {
                return new RuntimeOpts(this.jobNamespace, this.jobName, this.extraLabels, this.extraAnnotations, this.nodeSelectorLabels, this.resourceRequirements, this.tolerations);
            }

            public String toString() {
                return "BasicKubernetesManifestCustomizer.RuntimeOpts.RuntimeOptsBuilder(jobNamespace=" + this.jobNamespace + ", jobName=" + this.jobName + ", extraLabels=" + this.extraLabels + ", extraAnnotations=" + this.extraAnnotations + ", nodeSelectorLabels=" + this.nodeSelectorLabels + ", resourceRequirements=" + this.resourceRequirements + ", tolerations=" + this.tolerations + ")";
            }
        }
    }
}

