/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.auth;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import java.util.Optional;
import java.util.function.Function;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.FunctionAuthProvider;
import org.apache.pulsar.functions.proto.Function;

public interface KubernetesFunctionAuthProvider
extends FunctionAuthProvider {
    public void initialize(CoreV1Api var1);

    default public void initialize(CoreV1Api coreClient, byte[] caBytes, Function<Function.FunctionDetails, String> namespaceCustomizerFunc) {
        this.setCaBytes(caBytes);
        this.setNamespaceProviderFunc(namespaceCustomizerFunc);
        this.initialize(coreClient);
    }

    default public void setCaBytes(byte[] caBytes) {
    }

    default public void setNamespaceProviderFunc(Function<Function.FunctionDetails, String> funcDetails) {
    }

    public void configureAuthDataStatefulSet(V1StatefulSet var1, Optional<FunctionAuthData> var2);

    public static KubernetesFunctionAuthProvider getAuthProvider(String className) {
        return (KubernetesFunctionAuthProvider)Reflections.createInstance((String)className, KubernetesFunctionAuthProvider.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }
}

