/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming.internal;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import android.widget.Toast;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.streaming.R;
import io.straas.android.sdk.streaming.StreamManager;
import io.straas.android.sdk.streaming.screencast.ScreencastSession;

public final class ScreencastService
extends Service {
    private static final String b = ScreencastService.class.getSimpleName();
    private ScreencastSession c;
    boolean a = false;
    private NotificationManagerCompat d;
    private final ScreencastSession.SessionListener e = new ScreencastSession.SessionListener(){

        @Override
        public void updateNotification(Notification notification) {
            ScreencastService.this.d.notify(55688, notification);
        }

        @Override
        public void destroyService() {
            ScreencastService.this.stopSelf();
        }
    };

    @TargetApi(value=21)
    public static Intent a(Context context, Identity identity, Bundle bundle) {
        Intent intent = new Intent(context, ScreencastService.class);
        intent.putExtra("identity", (Parcelable)identity);
        intent.putExtra("screencast_config", bundle);
        return intent;
    }

    @TargetApi(value=21)
    public int onStartCommand(@NonNull Intent intent, int flags, int startId) {
        if (this.a) {
            return 2;
        }
        this.a = true;
        this.d = NotificationManagerCompat.from((Context)this);
        Identity identity = (Identity)intent.getParcelableExtra("identity");
        Bundle bundle = intent.getBundleExtra("screencast_config");
        this.a(identity, bundle);
        this.b();
        return 2;
    }

    @TargetApi(value=21)
    void a(Identity identity, Bundle bundle) {
        this.c = this.c();
        if (this.c != null) {
            this.c.onSessionCreate((Context)this, this.e, bundle);
            StreamManager.initialize(identity).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<StreamManager>(){

                public void onComplete(@NonNull Task<StreamManager> task) {
                    ScreencastService.this.c.onStreamManagerInitComplete(task);
                }
            });
            if (this.d()) {
                NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
                notificationManager.createNotificationChannel(this.c.getNotificationChannel());
            }
        }
    }

    void a() {
        if (this.c != null) {
            this.c.onSessionDestroy();
            this.c = null;
        }
    }

    private ScreencastSession c() {
        try {
            ApplicationInfo applicationInfo = this.getApplicationContext().getPackageManager().getApplicationInfo(this.getApplicationContext().getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            String string2 = bundle.getString("io.straas.android.sdk.streaming.SCREENCAST_SESSION_CLASS_NAME");
            Class<?> clazz = Class.forName(string2);
            return (ScreencastSession)clazz.newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            Log.e((String)b, (String)("ScreencastService start failed due to screencast session not found, exception:" + throwable));
            Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.hint_need_screencast_session), (int)1).show();
            this.stopSelf();
            return null;
        }
    }

    void b() {
        if (this.c != null) {
            this.startForeground(55688, this.c.getNotification());
        }
    }

    private boolean d() {
        return Build.VERSION.SDK_INT >= 26;
    }

    public void onDestroy() {
        Log.d((String)b, (String)"ScreencastService onDestroy");
        this.a();
        super.onDestroy();
    }

    public IBinder onBind(@NonNull Intent intent) {
        throw new AssertionError((Object)"Not supported.");
    }
}

