/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming.error;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Locale;

public interface StreamException {

    public static class UnavailableException
    extends Exception {
    }

    public static class InterruptedException
    extends java.lang.InterruptedException {
    }

    public static class EventExpiredException
    extends Exception {
    }

    public static class NotFoundException
    extends Exception {
    }

    public static class LiveCountLimitException
    extends Exception {
        private String mLiveId;

        public LiveCountLimitException(String liveId) {
            this.mLiveId = liveId;
        }

        public String getLiveId() {
            return this.mLiveId;
        }
    }

    public static class RequestRejectedException
    extends Exception {
        public RequestRejectedException(Throwable cause) {
            super(cause);
        }
    }

    public static class ServerException
    extends Exception {
        public ServerException(int statusCode) {
            super(String.format(Locale.ENGLISH, "HTTP status code: %d", statusCode));
        }

        public ServerException(String publishError) {
            super("Publish error: " + publishError);
        }
    }

    public static class UnauthorizedException
    extends GeneralSecurityException {
    }

    public static class InternalException
    extends Exception {
        public InternalException() {
        }

        public InternalException(Throwable cause) {
            super(cause);
        }

        public InternalException(String message) {
            super(message);
        }
    }

    public static class NetworkException
    extends IOException {
        public NetworkException(Throwable cause) {
            super(cause);
        }
    }
}

