/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming.proguard;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.view.TextureView;
import android.view.WindowManager;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.straas.android.sdk.authentication.credential.Credential;
import io.straas.android.sdk.authentication.identity.Identity;
import io.straas.android.sdk.authentication.internal.Utils;
import io.straas.android.sdk.streaming.BaseImageFilter;
import io.straas.android.sdk.streaming.CameraController;
import io.straas.android.sdk.streaming.LiveEventConfig;
import io.straas.android.sdk.streaming.ScreencastStreamConfig;
import io.straas.android.sdk.streaming.StreamConfig;
import io.straas.android.sdk.streaming.StreamManager;
import io.straas.android.sdk.streaming.StreamStatsReport;
import io.straas.android.sdk.streaming.error.PrepareException;
import io.straas.android.sdk.streaming.error.StreamException;
import io.straas.android.sdk.streaming.http.StreamEndPoint;
import io.straas.android.sdk.streaming.interfaces.EventListener;
import io.straas.android.sdk.streaming.internal.LiveEventStatus;
import io.straas.android.sdk.streaming.proguard.a;
import io.straas.android.sdk.streaming.proguard.ac;
import io.straas.android.sdk.streaming.proguard.ah;
import io.straas.android.sdk.streaming.proguard.al;
import io.straas.android.sdk.streaming.proguard.b;
import io.straas.android.sdk.streaming.proguard.c;
import io.straas.android.sdk.streaming.proguard.j;
import io.straas.android.sdk.streaming.proguard.z;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.ByteString;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;

public class d {
    private static final String a = d.class.getSimpleName();
    private j b;
    private String c;
    private Identity d;
    private StreamEndPoint e;
    private Handler f = new Handler();
    private final CallManager g = new CallManager();
    @StreamManager.StreamState
    private int h;
    private List<EventListener> i;
    private RetryDelayController j;
    private TaskCompletionSource<String> k;
    private TaskCompletionSource<Void> l;
    private boolean m;
    private final Object n = new Object();
    private TextureView o;
    private int p = 1000;
    private a q;
    private Runnable r = new Runnable(){

        @Override
        public void run() {
            d.this.a(d.this.i);
            d.this.f.removeCallbacks((Runnable)this);
            if (d.this.h == 4 || d.this.h == 5) {
                d.this.f.postDelayed((Runnable)this, (long)d.this.p);
            }
        }
    };
    private TextureView.SurfaceTextureListener s = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            if (d.this.b != null) {
                d.this.b.a(surface, width, height);
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            if (d.this.b != null) {
                d.this.b.a(width, height);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            if (d.this.b != null) {
                d.this.b.a(true);
                return false;
            }
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };
    private z t = new z(){

        @Override
        public void a(Exception exception, String string2) {
            if (exception == null && TextUtils.isEmpty((CharSequence)string2)) {
                d.this.h = 4;
                d.this.f.post(d.this.r);
                d.this.k.trySetResult((Object)d.this.c);
            } else {
                if (d.this.l != null) {
                    d.this.l.trySetResult(null);
                }
                if (d.this.m) {
                    d.this.k.trySetException((Exception)new StreamException.InterruptedException());
                } else {
                    Exception exception2;
                    if (string2 == null) {
                        exception2 = HttpTaskError.getThrowableMappingId(null, (Throwable)exception) == Integer.MIN_VALUE ? new StreamException.InternalException() : new StreamException.NetworkException(exception);
                    } else {
                        switch (Integer.parseInt(string2)) {
                            case 4008: {
                                exception2 = new StreamException.EventExpiredException();
                                break;
                            }
                            case 4004: {
                                exception2 = new StreamException.StreamOccupiedException();
                                break;
                            }
                            default: {
                                exception2 = new StreamException.ServerException(string2);
                            }
                        }
                    }
                    d.this.k.trySetException(exception2);
                }
            }
        }

        @Override
        public void a(final Exception exception) {
            if (d.this.h != 4) {
                return;
            }
            d.this.m = true;
            d.this.h = 5;
            d.this.c(false).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                public void a(Void void_) {
                    d.this.h = 2;
                    String string2 = d.this.c;
                    d.this.c = null;
                    d.this.a(d.this.i, (Exception)new StreamException.NetworkException(exception), string2);
                }

                public /* synthetic */ void onSuccess(Object object) {
                    this.a((Void)object);
                }
            });
        }

        @Override
        public void a(int n2) {
            if (d.this.l != null) {
                d.this.l.trySetResult(null);
            }
        }
    };

    public d(Identity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity shouldn't be null.");
        }
        this.h = 0;
        this.d = identity;
        this.e = this.a(identity);
        this.f();
    }

    @StreamManager.StreamState
    public int a() {
        return this.h;
    }

    public Task<CameraController> a(StreamConfig streamConfig, final @NonNull TextureView textureView) {
        ah ah2;
        if (this.h != 0 && this.h != 2) {
            return Tasks.forException((Exception)new PrepareException.RequestRejectedException(new IllegalStateException("This method should only be called when the StreamManager status is STATE_IDLE or STATE_PREPARED.")));
        }
        if (textureView == null) {
            return Tasks.forException((Exception)new PrepareException.RequestRejectedException(new IllegalArgumentException("preview shouldn't be null")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.h = 1;
        if (this.b == null) {
            this.b = new j();
        } else {
            this.o.setSurfaceTextureListener(null);
            this.b.a(false);
            this.b.c();
        }
        this.o = textureView;
        try {
            ah2 = this.a(Credential.getContext(), streamConfig);
        }
        catch (Exception exception) {
            this.h = 0;
            return Tasks.forException((Exception)new PrepareException.CameraInitFailException(exception));
        }
        if (streamConfig.getOutputWidth() <= 0 || streamConfig.getOutputHeight() <= 0) {
            ah2.c(streamConfig.getFitAllCamera());
            this.b(textureView).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                public void a(Void void_) {
                    ah2.a((float)textureView.getWidth() / (float)textureView.getHeight());
                    d.this.a(ah2, textureView, (TaskCompletionSource<CameraController>)taskCompletionSource);
                }

                public /* synthetic */ void onSuccess(Object object) {
                    this.a((Void)object);
                }
            });
        } else {
            ah2.a(new al(streamConfig.getOutputWidth(), streamConfig.getOutputHeight()));
            this.a(ah2, textureView, (TaskCompletionSource<CameraController>)taskCompletionSource);
        }
        return taskCompletionSource.getTask().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<CameraController>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(@NonNull Task<CameraController> task) {
                Object object = d.this.n;
                synchronized (object) {
                    d.this.n.notify();
                }
            }
        });
    }

    public Task<Void> a(ScreencastStreamConfig screencastStreamConfig) {
        ah ah2;
        if (this.h != 0 && this.h != 2) {
            return Tasks.forException((Exception)new PrepareException.RequestRejectedException(new IllegalStateException("This method should only be called when the StreamManager status is STATE_IDLE or STATE_PREPARED.")));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.h = 1;
        if (this.b == null) {
            this.b = new j();
        } else {
            this.b.c();
        }
        try {
            ah2 = this.b(screencastStreamConfig);
        }
        catch (Exception exception) {
            this.h = 0;
            return Tasks.forException((Exception)new PrepareException.ScreenCaptureInitFailException(exception));
        }
        this.a(ah2, (TaskCompletionSource<Void>)taskCompletionSource);
        return taskCompletionSource.getTask().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(@NonNull Task<Void> task) {
                Object object = d.this.n;
                synchronized (object) {
                    d.this.n.notify();
                }
            }
        });
    }

    private void a(ah ah2, TextureView textureView, TaskCompletionSource<CameraController> taskCompletionSource) {
        try {
            this.b.a(ah2);
            this.b.a(this.t);
            this.a(textureView);
            this.h = 2;
            taskCompletionSource.setResult((Object)this.a(this.b));
        }
        catch (Exception exception) {
            this.h = 0;
            taskCompletionSource.setException(exception);
        }
    }

    private void a(ah ah2, TaskCompletionSource<Void> taskCompletionSource) {
        try {
            this.b.a(ah2);
            this.b.a(this.t);
            this.h = 2;
            taskCompletionSource.setResult(null);
        }
        catch (Exception exception) {
            this.h = 0;
            taskCompletionSource.setException(exception);
        }
    }

    private CameraController a(final j j2) {
        return new CameraController(new b(){

            @Override
            public int a() {
                return j2.e();
            }

            @Override
            public boolean b() {
                return j2.k();
            }

            @Override
            public boolean c() {
                int n2 = this.a();
                while (!j2.d()) {
                    if (this.a() != n2) continue;
                    return false;
                }
                return n2 != this.a();
            }

            @Override
            public boolean d() {
                return j2.j();
            }
        });
    }

    private void a(TextureView textureView) {
        textureView.setSurfaceTextureListener(this.s);
        if (textureView.getSurfaceTexture() != null && textureView.getWidth() > 0 && textureView.getHeight() > 0) {
            this.b.a(textureView.getSurfaceTexture(), textureView.getWidth(), textureView.getHeight());
        }
    }

    private Task<Void> b(final TextureView textureView) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        textureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                textureView.setSurfaceTextureListener(null);
                taskCompletionSource.trySetResult(null);
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        if (textureView.getWidth() > 0 && textureView.getHeight() > 0) {
            textureView.setSurfaceTextureListener(null);
            taskCompletionSource.trySetResult(null);
        }
        return taskCompletionSource.getTask();
    }

    public boolean a(BaseImageFilter baseImageFilter) {
        if (this.h == 0 || this.h == 1 || this.b == null) {
            return false;
        }
        this.b.a(baseImageFilter != null ? new c<BaseImageFilter>(baseImageFilter) : null);
        return true;
    }

    public void a(boolean bl) {
        if (this.h == 0 || this.h == 1 || this.b == null) {
            Log.w((String)a, (String)("Wrong state to setAudioEnabled, state=" + this.h));
            return;
        }
        if (bl) {
            this.b.a((ac)null);
            if (this.q != null) {
                this.q.b();
                this.q = null;
            }
        } else {
            if (this.q == null) {
                this.q = new a(false);
            }
            this.b.a(this.q);
        }
    }

    public boolean b() {
        if (this.h == 0 || this.h == 1 || this.b == null) {
            return true;
        }
        return this.q == null || this.q.a();
    }

    public Task<String> a(@NonNull LiveEventConfig liveEventConfig) {
        if (this.h != 0 && this.h != 1 && this.h != 2) {
            StreamException.RequestRejectedException requestRejectedException = new StreamException.RequestRejectedException(new IllegalStateException("State must be STATE_IDLE, STATE_PREPARING, or STATE_PREPARED"));
            return Tasks.forException((Exception)requestRejectedException);
        }
        if (this.d.isGuest()) {
            return Tasks.forException((Exception)new StreamException.UnauthorizedException());
        }
        if (liveEventConfig == null) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException()));
        }
        StreamEndPoint.b b2 = new StreamEndPoint.b(liveEventConfig);
        return this.a(b2);
    }

    private Task<String> a(StreamEndPoint.b b2) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<StreamEndPoint.c> call = this.e.createLive(b2);
        call.enqueue((Callback)new CallManager.Callback<StreamEndPoint.c>(this.g, call, null){

            public void onResponse(Call<StreamEndPoint.c> call, retrofit2.Response<StreamEndPoint.c> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult((Object)((StreamEndPoint.c)response.body()).id);
                } else {
                    taskCompletionSource.setException(d.this.a(response));
                }
            }

            public void onFailure(Call<StreamEndPoint.c> call, Throwable t2) {
                super.onFailure(call, t2);
                switch (HttpTaskError.getThrowableMappingId(call, (Throwable)t2)) {
                    case 6: {
                        taskCompletionSource.setException((Exception)new StreamException.InterruptedException());
                        break;
                    }
                    case 7: {
                        taskCompletionSource.setException((Exception)new StreamException.InternalException(t2));
                        break;
                    }
                    default: {
                        taskCompletionSource.setException((Exception)new StreamException.NetworkException(t2));
                    }
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<StreamEndPoint.c> a(StreamEndPoint streamEndPoint, String string2) {
        Call<StreamEndPoint.c> call = streamEndPoint.getLiveWithOwner(string2, Credential.getKey());
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        call.enqueue((Callback)new CallManager.Callback<StreamEndPoint.c>(this.g, call, null){

            public void onResponse(Call<StreamEndPoint.c> call, retrofit2.Response<StreamEndPoint.c> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult(response.body());
                } else {
                    taskCompletionSource.setException(d.this.a(response));
                }
            }

            public void onFailure(Call<StreamEndPoint.c> call, Throwable t2) {
                super.onFailure(call, t2);
                switch (HttpTaskError.getThrowableMappingId(call, (Throwable)t2)) {
                    case 6: {
                        taskCompletionSource.setException((Exception)new StreamException.InterruptedException());
                        break;
                    }
                    case 7: {
                        taskCompletionSource.setException((Exception)new StreamException.InternalException(t2));
                        break;
                    }
                    default: {
                        taskCompletionSource.setException((Exception)new StreamException.NetworkException(t2));
                    }
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    public Task<Void> a(String string2) {
        if (this.d.isGuest()) {
            return Tasks.forException((Exception)new StreamException.UnauthorizedException());
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException("Live event id shouldn't be empty")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<StreamEndPoint.c> call = this.e.updateLive(string2, new StreamEndPoint.g(LiveEventStatus.ended));
        call.enqueue((Callback)new CallManager.Callback<StreamEndPoint.c>(null, call, null){

            public void onResponse(Call<StreamEndPoint.c> call, retrofit2.Response<StreamEndPoint.c> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                } else {
                    taskCompletionSource.setException(d.this.a(response));
                }
            }

            public void onFailure(Call<StreamEndPoint.c> call, Throwable t2) {
                super.onFailure(call, t2);
                switch (HttpTaskError.getThrowableMappingId(call, (Throwable)t2)) {
                    case 6: {
                        taskCompletionSource.setException((Exception)new StreamException.InterruptedException());
                        break;
                    }
                    case 7: {
                        taskCompletionSource.setResult(null);
                        break;
                    }
                    default: {
                        taskCompletionSource.setException((Exception)new StreamException.NetworkException(t2));
                    }
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    public Task<String> b(@NonNull String string2) {
        if (this.h != 2) {
            StreamException.RequestRejectedException requestRejectedException = new StreamException.RequestRejectedException(new IllegalStateException("State must be STATE_PREPARED."));
            return Tasks.forException((Exception)requestRejectedException);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException()));
        }
        this.h = 3;
        return this.a(this.e, string2).continueWithTask((Continuation)new Continuation<StreamEndPoint.c, Task<String>>(){

            public Task<String> a(@NonNull Task<StreamEndPoint.c> task) throws Exception {
                if (task.isSuccessful()) {
                    StreamEndPoint.c c2 = (StreamEndPoint.c)task.getResult();
                    String string2 = d.this.f(d.this.d.getToken());
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        d.this.h = 2;
                        throw new StreamException.UnauthorizedException();
                    }
                    if (c2 == null || c2.owner == null || !string2.equals(c2.owner.id) || c2.status == LiveEventStatus.ended) {
                        d.this.h = 2;
                        throw new StreamException.NotFoundException();
                    }
                    return d.this.a(c2);
                }
                d.this.h = 2;
                throw task.getException();
            }

            public /* synthetic */ Object then(@NonNull Task task) throws Exception {
                return this.a((Task<StreamEndPoint.c>)task);
            }
        });
    }

    public Task<String> a(StreamEndPoint.c c2) {
        String string2 = io.straas.android.sdk.streaming.proguard.d.a(c2.stream_server_url, c2.stream_key);
        this.c = c2.id;
        return this.e(string2);
    }

    public Task<Void> c(String string2) {
        if (this.h != 2) {
            StreamException.RequestRejectedException requestRejectedException = new StreamException.RequestRejectedException(new IllegalStateException("State must be STATE_PREPARED."));
            return Tasks.forException((Exception)requestRejectedException);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException()));
        }
        this.h = 3;
        return this.e(string2).continueWith((Continuation)new Continuation<String, Void>(){

            public Void a(@NonNull Task<String> task) throws Exception {
                if (task.isSuccessful()) {
                    return null;
                }
                throw task.getException();
            }

            public /* synthetic */ Object then(@NonNull Task task) throws Exception {
                return this.a((Task<String>)task);
            }
        });
    }

    public Task<Void> d(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException()));
        }
        String string3 = io.straas.android.sdk.streaming.proguard.d.a("rtmp://live-ea.straas.net/app", string2);
        return this.c(string3);
    }

    private Task<String> e(String string2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.b.a(string2);
        this.m = false;
        this.j.stop();
        this.a((TaskCompletionSource<String>)taskCompletionSource, null, true);
        return taskCompletionSource.getTask();
    }

    private void a(final TaskCompletionSource<String> taskCompletionSource, Exception exception, boolean bl) {
        if (!this.j.canRetry()) {
            this.a(taskCompletionSource, exception);
            return;
        }
        this.k = new TaskCompletionSource();
        this.k.getTask().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<String>(){

            public void a(String string2) {
                taskCompletionSource.setResult((Object)string2);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((String)object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                if (d.this.a(e2)) {
                    d.this.a((TaskCompletionSource<String>)taskCompletionSource, e2, false);
                } else {
                    d.this.a(taskCompletionSource, e2);
                }
            }
        });
        if (bl) {
            this.j.retryImmediately();
        } else {
            this.j.retry();
        }
    }

    private void f() {
        this.j = new RetryDelayController(new Retriable(){

            public void retry() {
                if (d.this.m) {
                    d.this.k.trySetException((Exception)new StreamException.InterruptedException());
                } else {
                    d.this.h = 3;
                    d.this.c(false).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                        public void a(Void void_) {
                            d.this.b.a();
                        }

                        public /* synthetic */ void onSuccess(Object object) {
                            this.a((Void)object);
                        }
                    });
                }
            }
        });
        this.j.enableExponentialBackoff(true);
        this.j.setMaxCount(2);
    }

    public Task<Void> b(boolean bl) {
        if (!bl && this.h != 3 && this.h != 4) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalStateException("State should be STATE_CONNECTING or STATE_STREAMING.")));
        }
        this.m = true;
        this.h = 5;
        this.g.cancelAllCalls();
        return this.c(bl).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> a(@NonNull Task<Void> task) throws Exception {
                d.this.h = 2;
                return task;
            }

            public /* synthetic */ Object then(@NonNull Task task) throws Exception {
                return this.a((Task<Void>)task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> c() {
        if (this.h == 0) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalStateException("State should be STATE_IDLE.")));
        }
        if (this.h == 1) {
            Object object = this.n;
            synchronized (object) {
                try {
                    this.n.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.b(true).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> a(@NonNull Task<Void> task) throws Exception {
                d.this.f.removeCallbacks(d.this.r);
                if (task.isSuccessful()) {
                    d.this.b.a(false);
                    d.this.b.c();
                    d.this.b = null;
                    if (d.this.q != null) {
                        d.this.q.b();
                        d.this.q = null;
                    }
                    if (d.this.o != null) {
                        d.this.o.setSurfaceTextureListener(null);
                        d.this.o = null;
                    }
                    d.this.h = 0;
                    return task;
                }
                return task;
            }

            public /* synthetic */ Object then(@NonNull Task task) throws Exception {
                return this.a((Task<Void>)task);
            }
        });
    }

    private Task<Void> c(boolean bl) {
        if (this.l != null && !this.l.getTask().isComplete()) {
            if (bl) {
                this.l.trySetException((Exception)new StreamException.InterruptedException());
            } else {
                return Tasks.forException((Exception)new IllegalStateException());
            }
        }
        this.l = new TaskCompletionSource();
        if (this.b != null && !this.b.b()) {
            this.l.setResult(null);
        }
        return this.l.getTask();
    }

    public boolean a(EventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        if (this.i == null) {
            this.i = new ArrayList<EventListener>();
        }
        if (this.i.size() > 1 && this.i.contains(eventListener)) {
            return false;
        }
        return this.i.add(eventListener);
    }

    public void a(EventListener ... eventListenerArray) {
        if (eventListenerArray == null) {
            return;
        }
        for (EventListener eventListener : eventListenerArray) {
            this.a(eventListener);
        }
    }

    public boolean b(EventListener eventListener) {
        return eventListener != null && this.i != null && this.i.remove(eventListener);
    }

    public void d() {
        if (this.i == null) {
            return;
        }
        this.i.clear();
    }

    public StreamStatsReport e() {
        if (this.h == 0 || this.b == null) {
            return null;
        }
        return new StreamStatsReport(this.b.h() * 8, this.b.f());
    }

    public void a(int n2) {
        this.p = n2;
    }

    private void a(final List<EventListener> list) {
        if (list == null) {
            return;
        }
        this.f.post(new Runnable(){

            @Override
            public void run() {
                if (!list.isEmpty()) {
                    StreamStatsReport streamStatsReport = d.this.e();
                    if (streamStatsReport == null) {
                        return;
                    }
                    for (EventListener eventListener : list) {
                        eventListener.onStreamStatsReportUpdate(streamStatsReport);
                    }
                }
            }
        });
    }

    private void a(final TaskCompletionSource taskCompletionSource, final Exception exception) {
        this.c(false).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                d.this.h = 2;
                taskCompletionSource.setException(exception);
            }
        });
    }

    private void a(final List<EventListener> list, final Exception exception, final String string2) {
        if (list == null) {
            return;
        }
        this.f.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(exception, string2);
                }
            }
        });
    }

    private StreamEndPoint a(Identity identity) {
        return (StreamEndPoint)Utils.createMemberRetrofit((String)"https://app.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                return chain.proceed(chain.request().newBuilder().addHeader("X-App-Token", Credential.getKey()).build());
            }
        }}).create(StreamEndPoint.class);
    }

    private ah a(Context context, StreamConfig streamConfig) throws Exception {
        ah ah2;
        block5: {
            Camera.CameraInfo cameraInfo;
            block4: {
                ah2 = ah.a();
                ah2.b(streamConfig.getCamera());
                ah2.b(streamConfig.getHighestResolution().getSize());
                ah2.b(streamConfig.getFrontCameraFlipHorizontally());
                try {
                    cameraInfo = this.b(1);
                    ah2.c(this.a(context, cameraInfo));
                }
                catch (Exception exception) {
                    if (streamConfig.getCamera() != 1) break block4;
                    throw exception;
                }
            }
            try {
                cameraInfo = this.b(0);
                ah2.d(this.a(context, cameraInfo));
            }
            catch (Exception exception) {
                if (streamConfig.getCamera() != 0) break block5;
                throw exception;
            }
        }
        return ah2;
    }

    private ah b(ScreencastStreamConfig screencastStreamConfig) throws Exception {
        if (screencastStreamConfig.getMediaProjection() == null) {
            throw new RuntimeException("Invalid media projection for screencast");
        }
        ah ah2 = ah.a();
        ah2.a(new al(screencastStreamConfig.getOutputWidth(), screencastStreamConfig.getOutputHeight()));
        ah2.a(screencastStreamConfig.getMediaProjection());
        ah2.i(screencastStreamConfig.getDensityDpi());
        return ah2;
    }

    private Camera.CameraInfo b(int n2) throws Exception {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
        return cameraInfo;
    }

    private int a(Context context, Camera.CameraInfo cameraInfo) {
        int n2;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        int n3 = windowManager.getDefaultDisplay().getRotation();
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
            }
        }
        if (cameraInfo.facing == 1) {
            n2 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n2) % 360;
        } else {
            n2 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        return this.c(n2);
    }

    private int c(int n2) {
        switch (n2) {
            case 0: {
                return 16;
            }
            case 90: {
                return 32;
            }
            case 180: {
                return 64;
            }
            case 270: {
                return 128;
            }
        }
        return 16;
    }

    private Exception a(retrofit2.Response response) {
        int n2 = response.code();
        switch (n2) {
            case 400: {
                return new StreamException.RequestRejectedException(new IllegalArgumentException());
            }
            case 401: {
                return new StreamException.UnauthorizedException();
            }
            case 403: 
            case 409: {
                return new StreamException.InternalException(this.a((ResponseBody)response.errorBody()).error);
            }
            case 423: {
                return new StreamException.UnavailableException();
            }
            case 404: {
                return new StreamException.NotFoundException();
            }
            case 422: {
                StreamEndPoint.f f2 = this.a(response.errorBody());
                if (f2 != null && !TextUtils.isEmpty((CharSequence)f2.parseLiveId())) {
                    return new StreamException.LiveCountLimitException(f2.parseLiveId());
                }
                return new StreamException.RequestRejectedException(new IllegalArgumentException());
            }
        }
        if (n2 >= 500 && n2 < 600) {
            return new StreamException.ServerException(response.code());
        }
        return new StreamException.InternalException();
    }

    private StreamEndPoint.f a(ResponseBody responseBody) {
        StreamEndPoint.f f2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            f2 = (StreamEndPoint.f)moshi.adapter(StreamEndPoint.f.class).fromJson((BufferedSource)responseBody.source().buffer().clone());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            f2 = new StreamEndPoint.f();
        }
        return f2;
    }

    private boolean a(Exception exception) {
        return !(exception instanceof StreamException.InterruptedException) && !(exception instanceof StreamException.EventExpiredException);
    }

    private String f(String string2) {
        String string3 = null;
        String string4 = string2.split("\\.")[1];
        try {
            String string5 = ByteString.decodeBase64((String)string4).utf8();
            JSONObject jSONObject = new JSONObject(string5);
            string3 = jSONObject.getString("member_id");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return string3;
    }

    private static String a(String string2, String string3) {
        return String.format("%s/%s", string2, string3);
    }
}

