/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming.base.rtmp;

import io.straas.android.sdk.streaming.base.rtmp.b.a;
import io.straas.android.sdk.streaming.base.rtmp.io.RtmpConnection;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;

public class Util {
    public static int toUnsignedInt24(byte[] byArray) {
        return (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
    }

    public static int toUnsignedInt16(byte[] byArray) {
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public static byte[] unsignedInt32ToByteArray(int n2) throws IOException {
        return new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
    }

    public static double readDouble(BufferedSource bufferedSource) throws IOException {
        Buffer buffer;
        if (!(bufferedSource instanceof Buffer)) {
            buffer = new Buffer();
            bufferedSource.readFully(buffer, 8L);
        } else {
            buffer = (Buffer)bufferedSource;
        }
        return Double.longBitsToDouble(buffer.readLong());
    }

    public static byte[] intToUnsignedInt24(int n2) {
        return new byte[]{(byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
    }

    public static byte[] intToUnsignedInt16(int n2) {
        return new byte[]{(byte)(n2 >>> 8), (byte)n2};
    }

    public static int readUnsignedInt24(BufferedSource bufferedSource) throws IOException {
        Buffer buffer;
        if (!(bufferedSource instanceof Buffer)) {
            buffer = new Buffer();
            bufferedSource.readFully(buffer, 3L);
        } else {
            buffer = (Buffer)bufferedSource;
        }
        return Util.toUnsignedInt24(buffer.readByteArray(3L));
    }

    public static int readUnsignedInt16(BufferedSource bufferedSource) throws IOException {
        Buffer buffer;
        if (!(bufferedSource instanceof Buffer)) {
            buffer = new Buffer();
            bufferedSource.readFully(buffer, 2L);
        } else {
            buffer = (Buffer)bufferedSource;
        }
        return Util.toUnsignedInt16(buffer.readByteArray(2L));
    }

    public static void rtmpPlay(RtmpConnection rtmpConnection, Sink sink) throws IOException {
        rtmpConnection.play(new a(sink), true);
    }
}

