/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.text.TextUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import org.json.JSONException;

public final class RawData
implements Parcelable {
    private final String a;
    public static final Parcelable.Creator<RawData> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<RawData>(){

        public RawData createFromParcel(Parcel in, ClassLoader loader) {
            return new RawData(in, loader);
        }

        public RawData[] newArray(int size) {
            return new RawData[size];
        }
    });

    private RawData(@NonNull String jsonText) {
        this.a = jsonText;
    }

    @NonNull
    public String getJsonText() {
        return this.a;
    }

    public <T> T getJsonTextAsData(Class<T> type) throws IOException, JSONException {
        Moshi moshi = new Moshi.Builder().build();
        try {
            return (T)moshi.adapter(type).fromJson(this.a);
        }
        catch (JsonDataException jsonDataException) {
            throw new JSONException(jsonDataException.getMessage());
        }
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof RawData && TextUtils.equals((CharSequence)((RawData)o2).getJsonText(), (CharSequence)this.a);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    protected RawData(Parcel in, ClassLoader loader) {
        this.a = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.a);
    }

    public static class Builder {
        private String a;

        public Builder() {
        }

        private Builder(RawData rawData) {
            this.a(rawData.getJsonText());
        }

        public Builder setJsonText(@NonNull String jsonString) {
            if (jsonString.length() < 2 || jsonString.length() > 2048) {
                throw new IllegalArgumentException("Raw data must be between 2~2048 characters.");
            }
            try {
                Object object = JsonReader.of((BufferedSource)new Buffer().writeUtf8(jsonString)).readJsonValue();
                if (object instanceof Map || object instanceof List) {
                    this.a = jsonString;
                    return this;
                }
                throw new IllegalArgumentException((Throwable)new JSONException("Not a valid JSON format"));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException((Throwable)new JSONException(iOException.getMessage()));
            }
        }

        Builder a(String string) {
            this.a = string;
            return this;
        }

        public <T> Builder setObject(T object) {
            String string;
            try {
                string = new Moshi.Builder().build().adapter(object.getClass()).toJson(object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
            this.setJsonText(string);
            return this;
        }

        public RawData build() {
            if (TextUtils.isEmpty((CharSequence)this.a)) {
                throw new IllegalStateException("Your JSON data is empty. Please use setObject or setJsonText first.");
            }
            return new RawData(this.a);
        }
    }
}

