/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.httptask.iKalaHttpUtils;
import com.ikala.android.utils.iKalaJSONUtil;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.client.SocketIOException;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.internal.Configuration;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.AggregatedData;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.http.MessagingEndpoint;
import io.straas.android.sdk.messaging.http.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.user.UserType;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

final class a {
    private static final String[] a = new String[]{"websocket"};
    private ChatroomState b = ChatroomState.IDLE;
    private int c;
    private String d;
    private Identity e;
    private boolean f;
    private List<EventListener> g;
    private int h;
    private SimpleArrayMap<String, String> i;
    private SimpleArrayMap<String, Integer> j;
    private List<Sticker> k;
    private String l;
    private String m;
    private Integer n;
    private User o;
    private MessagingEndpoint.n p;
    private boolean q;
    private MessagingEndpoint r;
    private final CallManager s = new CallManager();
    private RetryDelayController t;
    private String u;
    private SharedPreferences v;
    private Handler w = new Handler();
    private c x;
    private TaskCompletionSource<Void> y;
    private io.straas.android.sdk.messaging.b z;
    private ChatMode A = ChatMode.ALL;
    private a.a B = new a.a(){

        @Override
        public void a(String string) {
            a.this.u = string;
            if (a.this.v != null) {
                a.this.v.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer C = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(new MessagingException.InternalException("timeout"));
        }
    };

    a(Context context) {
        this.k();
        this.v = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void k() {
        this.t = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.b = ChatroomState.CONNECTING;
                if (a.this.p != null) {
                    a.this.a(a.this.p);
                } else {
                    a.this.a(true);
                }
            }
        });
        this.t.setMaxCount(7);
        this.t.enableExponentialBackoff(true);
        this.t.setBaseRetryInterval(500L);
        this.j = new SimpleArrayMap();
        this.g = new ArrayList<EventListener>();
    }

    private MessagingEndpoint b(Identity identity) {
        return (MessagingEndpoint)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.http.a.a("https://mgr.straas.net", this.B)}).create(MessagingEndpoint.class);
    }

    Task<Void> a(@NonNull String string, @NonNull Identity identity) {
        MessagingException.RequestRejectedException requestRejectedException = null;
        if (this.b != ChatroomState.IDLE) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalStateException("State must be IDLE."));
        }
        if (TextUtils.isEmpty((CharSequence)string) || identity == null) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalArgumentException("Check chatroom name or Identity."));
        }
        if (requestRejectedException != null) {
            return Tasks.forException((Exception)requestRejectedException);
        }
        this.y = new TaskCompletionSource();
        this.b = ChatroomState.CONNECTING;
        this.e = identity;
        this.d = string;
        this.f = string.startsWith("p#");
        this.r = this.b(identity);
        this.z = new io.straas.android.sdk.messaging.b(this.r);
        this.t.stop();
        this.q = false;
        this.m();
        return this.y.getTask();
    }

    boolean a(Identity identity) {
        if (this.b.equals((Object)ChatroomState.CONNECTED)) {
            this.e = identity;
            this.r = this.b(identity);
            return true;
        }
        return false;
    }

    private void l() {
        if (!TextUtils.isEmpty((CharSequence)this.u)) {
            return;
        }
        String string = null;
        if (this.v != null) {
            string = this.v.getString("KEY_API_TOKEN", null);
        }
        this.u = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(int n2) {
        switch (n2) {
            case 0: {
                this.n();
                break;
            }
            case 1: {
                this.o();
                break;
            }
            case 2: {
                this.p();
            }
        }
    }

    private void m() {
        this.b = ChatroomState.CONNECTING;
        this.l();
        this.a(0);
    }

    private void n() {
        final String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(new MessagingException.InternalException("check your sdk account_id"));
            this.j();
        }
        Call<MessagingEndpoint.h> call = this.r.getChatProfileByChannel(this.u, this.d, string);
        call.enqueue((Callback)new a<MessagingEndpoint.h>(this.s, call, null){

            @Override
            public void onResponse(Call<MessagingEndpoint.h> call, Response<MessagingEndpoint.h> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.l = ((MessagingEndpoint.h)response.body()).id;
                    a.this.c = ((MessagingEndpoint.h)response.body()).inputInterval;
                    a.this.A = ChatMode.a(((MessagingEndpoint.h)response.body()).chatWriteMode);
                    a.this.h = ((MessagingEndpoint.h)response.body()).guestCount + ((MessagingEndpoint.h)response.body()).memberCount;
                    a.this.i = ((MessagingEndpoint.h)response.body()).getStickerMap();
                    a.this.k = ((MessagingEndpoint.h)response.body()).getStickerSuite();
                    if (a.this.j.size() == 0) {
                        for (Map map : ((MessagingEndpoint.h)response.body()).aggregated) {
                            a.this.j.put((Object)((String)map.get("key")), (Object)((Double)map.get("n")).intValue());
                        }
                    } else {
                        SimpleArrayMap simpleArrayMap = new SimpleArrayMap();
                        for (Map object : ((MessagingEndpoint.h)response.body()).aggregated) {
                            String string2 = (String)object.get("key");
                            int n2 = ((Double)object.get("n")).intValue();
                            if (a.this.j.containsKey((Object)string2)) {
                                if ((Integer)a.this.j.get((Object)string2) == n2) continue;
                                int n3 = n2 - (Integer)a.this.j.get((Object)string2);
                                a.this.j.put((Object)string2, (Object)n2);
                                simpleArrayMap.put((Object)string2, (Object)n3);
                                continue;
                            }
                            a.this.j.put((Object)string2, (Object)n2);
                            simpleArrayMap.put((Object)string2, (Object)n2);
                        }
                        if (simpleArrayMap.size() > 0) {
                            for (EventListener eventListener : a.this.g) {
                                eventListener.onAggregatedDataAdded((SimpleArrayMap<String, Integer>)simpleArrayMap);
                            }
                        }
                    }
                    a.this.a(1);
                }
            }

            @Override
            protected void a(Exception exception) {
                if (exception instanceof MessagingException.NotFoundException) {
                    exception = new MessagingException.ChatroomNameNotFoundException(exception.getMessage());
                }
                if (exception instanceof MessagingException.ChatroomNameNotFoundException && a.this.f && !a.this.e.isGuest()) {
                    a.this.a(a.this.d, string);
                } else {
                    super.a(exception);
                }
            }
        });
    }

    private void a(String string, String string2) {
        Call<ResponseBody> call = this.r.createPersonalChat(this.u, new MessagingEndpoint.f(ChatroomInfo.a(string), string2));
        call.enqueue((Callback)new a<ResponseBody>(this.s, call, null){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful()) {
                    a.this.a(0);
                }
            }

            @Override
            protected void a(Exception exception) {
                if (exception instanceof MessagingException.UnauthorizedException) {
                    exception = new MessagingException.ChatroomNameNotFoundException();
                }
                super.a(exception);
            }
        });
    }

    private void o() {
        String string = this.e == Identity.GUEST ? "Guest" : null;
        Call<MessagingEndpoint.c> call = this.r.addUsersToChat(this.u, new MessagingEndpoint.b(this.l, this.m, string));
        call.enqueue((Callback)new a<MessagingEndpoint.c>(this.s, call, null){

            @Override
            public void onResponse(Call<MessagingEndpoint.c> call, Response<MessagingEndpoint.c> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    MessagingEndpoint.c.a a2 = ((MessagingEndpoint.c)response.body()).userMetas[0];
                    a.this.m = a2.userToken;
                    a.this.n = (Integer)a2.label;
                    a.this.o = new User.a(((MessagingEndpoint.c)response.body()).userModel).a();
                    a.this.p = ((MessagingEndpoint.c)response.body()).socket;
                    a.this.a(a.this.p);
                }
            }
        });
    }

    private void p() {
        this.t.stop();
        this.b = ChatroomState.CONNECTED;
        if (!this.q) {
            this.q = true;
            if (this.y != null) {
                this.y.trySetResult(null);
                this.y = null;
            }
            this.c(this.g);
        }
        this.z.a(this.u, this.m, this.l, this.h);
    }

    private void a(MessagingEndpoint.n n2) {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.path = n2.path;
        options.query = (!TextUtils.isEmpty((CharSequence)n2.query) ? n2.query + "&" : "") + "userAgent=" + Configuration.USER_AGENT;
        options.transports = a;
        options.timeout = 30000L;
        options.callFactory = iKalaHttpUtils.getOkHttpClient();
        options.webSocketFactory = iKalaHttpUtils.getOkHttpClient();
        try {
            socket = IO.socket((String)n2.host, (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.p = null;
            this.a(new MessagingException.InternalException(uRISyntaxException.getMessage()));
            return;
        }
        this.x = new c(socket);
        this.a(this.x);
        this.b(this.x);
        socket.connect();
    }

    private void a(final c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("connect", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.C.start();
                c2.a("subscribe", a.this.m, a.this.l);
            }
        });
        c2.a("connect_error", new Emitter.Listener(){

            public void call(Object ... args) {
                Object object = args.length > 0 ? args[0] : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException("Connection error", (Throwable)(object instanceof Exception ? (Exception)object : null))));
            }
        });
        c2.a("disconnect", new Emitter.Listener(){

            public void call(Object ... args) {
                if (!a.this.t()) {
                    return;
                }
                Object object = args.length > 0 ? args[0] : null;
                String string = object instanceof String ? (String)object : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException(string)));
            }
        });
    }

    private void b(c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("subscribed", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.C.cancel();
                a.this.o.a("ACTIVE");
                a.this.h++;
                a.this.a(2);
            }
        });
        c2.a("message", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a(a.this.g, Message.a(jSONObject, (SimpleArrayMap<String, String>)a.this.i), 0L);
            }
        });
        c2.a("raw_data", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a((List<EventListener>)a.this.g, Message.a(jSONObject, null));
            }
        });
        c2.a("agg_data", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a(iKalaJSONUtil.getJSONArray((JSONObject)jSONObject, (String)"aggregated"));
            }
        });
        c2.a("message_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof String)) {
                    return;
                }
                String string = (String)args[0];
                a.this.a((List<EventListener>)a.this.g, string);
            }
        });
        c2.a("message_flush", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.e(a.this.g);
            }
        });
        c2.a("user_add", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (a.this.n != null && a.this.n.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                    a.this.h++;
                }
                if (arrayList.size() != 0) {
                    User[] userArray = arrayList.toArray(new User[0]);
                    a.this.a((List<EventListener>)a.this.g, userArray);
                    a.this.a((List<EventListener>)a.this.g, a.this.h);
                    a.this.z.a(userArray);
                }
            }
        });
        c2.a("user_update", new Emitter.Listener(){

            public void call(Object ... args) {
                int n2 = 0;
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (a.this.n == null || a.this.n.intValue() != user.getLabel().intValue()) continue;
                    a.this.o = user;
                }
                if (arrayList.size() != 0) {
                    User[] userArray = arrayList.toArray(arrayList.toArray(new User[0]));
                    a.this.b((List<EventListener>)a.this.g, userArray);
                    a.this.z.b(userArray);
                }
            }
        });
        c2.a("user_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n3) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (a.this.n != null && n3 == a.this.n) {
                        switch (string) {
                            case "DELETED": {
                                if (!a.this.t()) break;
                                break;
                            }
                        }
                    } else {
                        Object object = new User.a();
                        ((User.a)object).a(n3).a(string);
                        arrayList.add(n3);
                    }
                    a.this.h--;
                    a.this.h = a.this.h >= 1 ? a.this.h : 1;
                }
                if (arrayList.size() != 0) {
                    Integer[] integerArray = arrayList.toArray(new Integer[0]);
                    a.this.a((List<EventListener>)a.this.g, integerArray);
                    a.this.a((List<EventListener>)a.this.g, a.this.h);
                    a.this.z.a(integerArray);
                }
            }
        });
        c2.a("user_count", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.h = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount") + iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                a.this.a((List<EventListener>)a.this.g, a.this.h);
                a.this.z.a(a.this.h);
            }
        });
        c2.a("error", new Emitter.Listener(){

            public void call(Object ... args) {
            }
        });
        c2.a("chat_write_mode", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                a.this.A = ChatMode.a(string);
                a.this.a((List<EventListener>)a.this.g, a.this.g());
            }
        });
        c2.a("message_input_interval", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(a.this.l)) {
                    return;
                }
                a.this.c = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                a.this.b((List<EventListener>)a.this.g, a.this.h());
            }
        });
    }

    boolean a(EventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        return !this.g.contains(eventListener) && this.g.add(eventListener);
    }

    void a(EventListener ... eventListenerArray) {
        if (eventListenerArray == null) {
            return;
        }
        for (EventListener eventListener : eventListenerArray) {
            this.a(eventListener);
        }
    }

    boolean b(EventListener eventListener) {
        return eventListener != null && !this.g.isEmpty() && this.g.remove(eventListener);
    }

    void a() {
        if (this.g.isEmpty()) {
            return;
        }
        this.g.clear();
    }

    private void c(final List<EventListener> list) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Exception exception) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnectFailed(exception);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final Exception exception) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(exception);
                }
            }
        });
    }

    private void d(final List<EventListener> list) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onDisconnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message, long l2) {
        this.w.postDelayed(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageAdded(message);
                }
            }
        }, l2);
    }

    private void a(final List<EventListener> list, final String string) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageRemoved(string);
                }
            }
        });
    }

    private void e(final List<EventListener> list) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageFlushed();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final User[] userArray) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserJoined(userArray);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final User[] userArray) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserUpdated(userArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Integer[] integerArray) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserLeft(integerArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final int n2) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.userCount(n2);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final ChatMode chatMode) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onChatWriteModeChanged(chatMode);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final int n2) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onInputIntervalChanged(n2);
                }
            }
        });
    }

    private void a(JSONArray jSONArray) {
        if (jSONArray == null || this.g.isEmpty()) {
            return;
        }
        final SimpleArrayMap simpleArrayMap = new SimpleArrayMap(jSONArray.length());
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
            if (jSONObject == null || !jSONObject.has("key")) continue;
            String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"key", (String)"", (boolean)false);
            int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"n", (int)0);
            if (TextUtils.isEmpty((CharSequence)string) || n3 == 0) continue;
            simpleArrayMap.put((Object)string, (Object)n3);
            Integer n4 = (Integer)this.j.get((Object)string);
            this.j.put((Object)string, (Object)(n4 == null ? n3 : n4 + n3));
        }
        if (simpleArrayMap.size() == 0) {
            return;
        }
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : a.this.g) {
                    eventListener.onAggregatedDataAdded((SimpleArrayMap<String, Integer>)simpleArrayMap);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onRawDataAdded(message);
                }
            }
        });
    }

    Task<Message[]> a(MessageRequest messageRequest, String string) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"aggregate")) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Please use getAggregatedDataHistory")));
        }
        int n2 = messageRequest.getPerPage();
        int n3 = messageRequest.getPage();
        if (!this.a(n3, n2, 100)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n3 - 1) * n2;
        Call<MessagingEndpoint.i> call = this.r.getMessagesByChat(this.u, this.m, this.l, n4, n2, messageRequest.getOldestDate(), messageRequest.getLatestDate(), messageRequest.getOrder(), string);
        call.enqueue((Callback)new b<MessagingEndpoint.i>(this.s, call, taskCompletionSource){

            @Override
            public void onResponse(Call<MessagingEndpoint.i> call, Response<MessagingEndpoint.i> response) {
                super.onResponse(call, response);
                MessagingEndpoint.i i2 = (MessagingEndpoint.i)response.body();
                if (!response.isSuccessful() || i2 == null || i2.messages == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = i2.messages.length;
                Message[] messageArray = new Message[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    Message message;
                    messageArray[i3] = message = new Message.Builder(i2.messages[i3], (SimpleArrayMap<String, String>)a.this.i).build();
                }
                taskCompletionSource.setResult((Object)messageArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    SimpleArrayMap<String, Integer> b() {
        return this.j;
    }

    Task<User[]> a(UserType userType) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        return this.z.a(userType);
    }

    Task<ChatroomInfo> c() {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            MessagingException.InternalException internalException = new MessagingException.InternalException("check your sdk account_id");
            return Tasks.forException((Exception)internalException);
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<MessagingEndpoint.h> call = this.r.getChatProfileByChannel(this.u, this.d, string);
        call.enqueue((Callback)new b<MessagingEndpoint.h>(this.s, call, taskCompletionSource){

            @Override
            public void onResponse(Call<MessagingEndpoint.h> call, Response<MessagingEndpoint.h> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult((Object)((MessagingEndpoint.h)response.body()).toChatroomInfo());
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(String string, Object object) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string.equals("text") && object instanceof CharSequence) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)object))) {
                return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message is empty, say something please.")));
            }
            if (((CharSequence)object).length() > 300) {
                return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message should be within 300 characters.")));
            }
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.r.addUserMessageToChat(this.u, new MessagingEndpoint.a(this.l, this.m, string, object));
        call.enqueue((Callback)new b<ResponseBody>(this.s, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    void a(Message message) {
        this.a(this.g, message, 100L);
    }

    Task<Void> a(final String string) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new IllegalStateException("State must be CONNECTED."));
        }
        if (this.e != Identity.GUEST) {
            return Tasks.forException((Exception)new IllegalStateException("Identity must be Identity.GUEST."));
        }
        return this.b(new MessagingEndpoint.o((int)this.n, string)).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                a.this.o.setName(string);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        });
    }

    Task<Void> a(MessagingEndpoint.o o2) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (!this.q()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        return this.b(o2);
    }

    Task<Void> b(MessagingEndpoint.o o2) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.r.updateUser(this.u, new MessagingEndpoint.p(this.l, this.m, Collections.singletonList(o2)));
        call.enqueue((Callback)new b<ResponseBody>(this.s, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }

            @Override
            protected void a(Call<ResponseBody> call, Exception exception) {
                if (exception instanceof MessagingException.NotFoundException) {
                    exception = new MessagingException.UserNotFoundException(exception.getMessage());
                }
                super.a(call, exception);
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(List<User> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User call2 : list) {
            arrayList.add(call2.getLabel());
        }
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are empty")));
        }
        if (!this.q()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.r.blockUsersInChat(this.u, new MessagingEndpoint.e(this.l, this.m, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.s, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> b(List<User> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User call2 : list) {
            arrayList.add(call2.getLabel());
        }
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are empty")));
        }
        if (!this.q()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.r.reviveUsersInChat(this.u, new MessagingEndpoint.e(this.l, this.m, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.s, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> b(Message message) {
        String string = message.getId();
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check message ID.")));
        }
        if (!this.q()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.r.removeMessageFromChat(this.u, this.m, this.l, string);
        call.enqueue((Callback)new b<ResponseBody>(this.s, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    private boolean q() {
        Role role = this.o.getRole();
        return role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER || role == Role.MASTER || role == Role.MODERATOR;
    }

    Task<AggregatedData[]> a(MessageRequest messageRequest) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        int n2 = messageRequest.getPerPage();
        int n3 = messageRequest.getPage();
        if (!this.a(n3, n2, 100)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n3 - 1) * n2;
        Call<MessagingEndpoint.g> call = this.r.getAggregatedDataByChat(this.u, this.m, this.l, n4, n2, messageRequest.getOldestDate(), messageRequest.getLatestDate(), messageRequest.getOrder());
        call.enqueue((Callback)new b<MessagingEndpoint.g>(this.s, call, taskCompletionSource){

            @Override
            public void onResponse(Call<MessagingEndpoint.g> call, Response<MessagingEndpoint.g> response) {
                super.onResponse(call, response);
                MessagingEndpoint.g g2 = (MessagingEndpoint.g)response.body();
                if (!response.isSuccessful() || g2 == null || g2.messages == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = g2.messages.length;
                AggregatedData[] aggregatedDataArray = new AggregatedData[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    aggregatedDataArray[i2] = new AggregatedData();
                    aggregatedDataArray[i2].b = io.straas.android.sdk.messaging.c.a(g2.messages[i2].createdDate);
                    for (Map map : g2.messages[i2].aggregated) {
                        aggregatedDataArray[i2].a.put((Object)((String)map.get("key")), (Object)((Double)map.get("n")).intValue());
                    }
                }
                taskCompletionSource.setResult((Object)aggregatedDataArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    List<Sticker> d() {
        return this.k;
    }

    User e() {
        return this.o;
    }

    int f() {
        return this.h;
    }

    ChatMode g() {
        return this.A;
    }

    int h() {
        return this.c;
    }

    ChatroomState i() {
        return this.b;
    }

    Task<Void> j() {
        if (!this.t()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException()));
        }
        return this.a(false);
    }

    private Task<Void> a(boolean bl) {
        if (bl) {
            this.b = ChatroomState.CONNECTING;
            this.z.a();
        } else {
            this.b = ChatroomState.DISCONNECTING;
            this.t.stop();
            this.z.b();
            this.j.clear();
        }
        this.s.cancelAllCalls();
        this.s();
        if (iKalaUtils.isEmptyString((CharSequence)this.m) || iKalaUtils.isEmptyString((CharSequence)this.l) || this.n == null) {
            if (bl) {
                this.m();
            }
        } else {
            this.b(bl);
            this.r();
        }
        if (!bl) {
            this.b = ChatroomState.IDLE;
            if (this.q) {
                this.d(this.g);
                return Tasks.forResult(null);
            }
        }
        return Tasks.forException((Exception)new Exception());
    }

    private void r() {
        this.l = null;
        this.m = null;
        this.n = null;
    }

    private synchronized void s() {
        if (this.x == null) {
            return;
        }
        this.x.a.off();
        this.x.a.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.r.removeUsersFromChat(this.u, this.m, this.l, Collections.singletonList(this.n));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.s, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.m();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                super.onFailure(call, t);
                Exception exception = a.this.a(call, t);
                if (bl && !(exception instanceof InterruptedIOException)) {
                    a.this.m();
                }
            }
        });
    }

    private void a(Exception exception) {
        if (!this.t()) {
            this.b(exception);
            return;
        }
        if (!this.c(exception) || !this.t.retry()) {
            this.j();
            this.b(exception);
        }
    }

    private void b(Exception exception) {
        if (!this.q) {
            this.a(this.g, exception);
            if (this.y != null) {
                this.y.trySetException(exception);
            }
        } else if (!(exception instanceof InterruptedIOException)) {
            this.b(this.g, exception);
        }
    }

    private boolean c(Exception exception) {
        if (exception instanceof MessagingException.NetworkException || exception instanceof MessagingException.InternalException || exception instanceof MessagingException.ServerException) {
            return true;
        }
        if (exception instanceof MessagingException.UnauthorizedException || exception instanceof MessagingException.PermissionException || exception instanceof MessagingException.ChatroomNameNotFoundException || exception instanceof MessagingException.RequestRejectedException || exception instanceof InterruptedIOException) {
            return false;
        }
        return false;
    }

    private Exception a(Response response) {
        int n2 = response.code();
        MessagingEndpoint.m m2 = this.a(response.errorBody());
        if (m2 == null || m2.code == null) {
            return new MessagingException.InternalException("Unknown error");
        }
        switch (n2) {
            case 401: {
                if (!m2.code.equals("UnauthorizedError")) break;
                return new MessagingException.UnauthorizedException();
            }
            case 403: {
                if (!m2.code.equals("PermissionViolationError")) break;
                return new MessagingException.PermissionException();
            }
            case 404: {
                if (!m2.code.equals("EntityNotFoundError")) break;
                return new MessagingException.NotFoundException(m2.message);
            }
            case 409: {
                if (!m2.code.equals("DuplicateEntityError") && !m2.code.equals("InvalidRequestError")) break;
                return new MessagingException.InternalException(Integer.toString(n2));
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: {
                return new MessagingException.ServerException(n2);
            }
            case 400: {
                return new MessagingException.InternalException(Integer.toString(n2));
            }
            default: {
                return new MessagingException.InternalException();
            }
        }
        return new MessagingException.InternalException();
    }

    private Exception a(Call call, Throwable throwable) {
        int n2 = HttpTaskError.getThrowableMappingId((Call)call, (Throwable)throwable);
        switch (n2) {
            case 6: {
                return new InterruptedIOException("canceled");
            }
        }
        return new MessagingException.NetworkException(throwable);
    }

    private boolean t() {
        return this.b == ChatroomState.CONNECTING || this.b == ChatroomState.CONNECTED;
    }

    private MessagingEndpoint.m a(ResponseBody responseBody) {
        MessagingEndpoint.m m2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            m2 = (MessagingEndpoint.m)moshi.adapter(MessagingEndpoint.m.class).fromJson(responseBody.source());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            m2 = new MessagingEndpoint.m();
        }
        return m2;
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 > 0 && n3 > 0 && n3 <= n4;
    }

    private static final class c {
        Socket a;

        c(Socket socket) {
            this.a = socket;
        }

        Emitter a(String string, Object ... objectArray) {
            return this.a.emit(string, objectArray);
        }

        Emitter a(String string, Emitter.Listener listener) {
            return this.a.on(string, listener);
        }
    }

    private class b<T>
    extends CallManager.Callback<T> {
        private int b;
        private final TaskCompletionSource c;

        b(@Nullable CallManager callManager, @Nullable Call call, TaskCompletionSource taskCompletionSource) {
            super(callManager, call, null);
            this.b = 0;
            this.c = taskCompletionSource;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                this.a(call, a.this.a(response));
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            super.onFailure(call, t);
            this.a(call, a.this.a(call, t));
        }

        protected void a(final Call<T> call, Exception exception) {
            if (++this.b <= 3 && a.this.t() && a.this.c(exception)) {
                a.this.w.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)b.this);
                    }
                }, 1000L);
            } else if (this.c != null && !(exception instanceof InterruptedIOException)) {
                this.c.trySetException(exception);
            }
        }
    }

    private class a<T>
    extends CallManager.Callback<T> {
        a(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                this.a(a.this.a(response));
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            super.onFailure(call, t);
            this.a(a.this.a(call, t));
        }

        protected void a(Exception exception) {
            a.this.a(exception);
        }
    }
}

