/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging.http;

import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import proguard.annotation.KeepClassMembers;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface MessagingEndpoint {
    @GET(value="/get-chat-profile-by-channel/{apiToken}?return_sticker=true")
    public Call<h> getChatProfileByChannel(@Path(value="apiToken") String var1, @Query(value="channelCode") String var2, @Query(value="platform") String var3);

    @POST(value="/add-users-to-chat/{apiToken}")
    public Call<c> addUsersToChat(@Path(value="apiToken") String var1, @Body b var2);

    @GET(value="/get-users-by-chat/{apiToken}")
    public Call<j> getUsersByChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="statuses[]") List<String> var4, @Query(value="roles[]") List<Role> var5, @Query(value="count") Integer var6, @Query(value="offset") Integer var7);

    @GET(value="/get-messages-by-chat/{apiToken}?categories[]=USER&populateCreator=true")
    public Call<i> getMessagesByChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="offset") Integer var4, @Query(value="count") Integer var5, @Query(value="oldestDate") Long var6, @Query(value="latestDate") Long var7, @Query(value="order") String var8, @Query(value="msgType") String var9);

    @GET(value="/get-messages-by-chat/{apiToken}?categories[]=USER&msgType=aggregate")
    public Call<g> getAggregatedDataByChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="offset") Integer var4, @Query(value="count") Integer var5, @Query(value="oldestDate") Long var6, @Query(value="latestDate") Long var7, @Query(value="order") String var8);

    @POST(value="/add-user-message-to-chat/{apiToken}")
    public Call<ResponseBody> addUserMessageToChat(@Path(value="apiToken") String var1, @Body a var2);

    @PUT(value="/update-users-in-chat/{apiToken}")
    public Call<ResponseBody> updateUser(@Path(value="apiToken") String var1, @Body p var2);

    @PUT(value="/block-users-in-chat/{apiToken}")
    public Call<ResponseBody> blockUsersInChat(@Path(value="apiToken") String var1, @Body e var2);

    @PUT(value="/revive-users-in-chat/{apiToken}")
    public Call<ResponseBody> reviveUsersInChat(@Path(value="apiToken") String var1, @Body e var2);

    @DELETE(value="/remove-users-from-chat/{apiToken}")
    public Call<ResponseBody> removeUsersFromChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="targetUserLabels[]") List<Integer> var4);

    @DELETE(value="/remove-message-from-chat/{apiToken}")
    public Call<ResponseBody> removeMessageFromChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="messageId") String var4);

    @POST(value="/v2/chat/{apiToken}")
    public Call<ResponseBody> createPersonalChat(@Path(value="apiToken") String var1, @Body f var2);

    @KeepClassMembers
    public static class q {
        public String userId;
        public String name;
        public String avatar;
        public int label = -1;
        public String status;
        public boolean isAdmin;
        public String role;
    }

    @KeepClassMembers
    public static class d {
        public List<Map> aggregated;
        public String createdDate;
    }

    @KeepClassMembers
    public static class k {
        public String id;
        public String category;
        public String type;
        public String status;
        public String text;
        public String link;
        public String createdDate;
        public Object value;
        public q creator;
    }

    @KeepClassMembers
    public static class f {
        private final String channel_code;
        private final String platform;
        private final boolean is_personal_chat = true;

        public f(String string, String string2) {
            this.channel_code = string;
            this.platform = string2;
        }
    }

    @KeepClassMembers
    public static class e
    extends l {
        private List<Integer> targetUserLabels;

        public e(String string, String string2, List<Integer> list) {
            super(string, string2);
            this.targetUserLabels = list;
        }
    }

    @KeepClassMembers
    public static class p
    extends l {
        private List<o> targetUsers;

        public p(String string, String string2, List<o> list) {
            super(string, string2);
            this.targetUsers = list;
        }
    }

    @KeepClassMembers
    public static class a
    extends l {
        private final String text;
        private final String link;
        private final Object value;
        private final String sourceType = "ANDROID";
        private final String msgType;

        public a(String string, String string2, @NonNull String string3, @NonNull Object object) {
            super(string, string2);
            this.link = null;
            switch (this.msgType = string3) {
                case "aggregate": 
                case "raw": {
                    this.value = object;
                    this.text = null;
                    break;
                }
                default: {
                    this.text = (String)object;
                    this.value = null;
                }
            }
        }
    }

    @KeepClassMembers
    public static class g {
        public d[] messages;
    }

    @KeepClassMembers
    public static class i {
        public k[] messages;
    }

    @KeepClassMembers
    public static class j {
        public q[] users;
    }

    @KeepClassMembers
    public static class o {
        private Role role;
        private String name;
        private Integer label = null;
        private String platform;
        private String memberId;

        public o(Role role) {
            this.role = role;
        }

        public o(String string) {
            this.name = string;
        }

        public o(int n2, String string) {
            this(string);
            this.label = n2;
        }

        public o(int n2, Role role) {
            this(role);
            this.label = n2;
        }

        public o(String string, String string2, Role role) {
            this(role);
            this.platform = string;
            this.memberId = string2;
        }
    }

    @KeepClassMembers
    public static class m {
        public String message;
        public String code;

        public String toString() {
            return (!TextUtils.isEmpty((CharSequence)this.code) ? this.code : "null") + ": " + (!TextUtils.isEmpty((CharSequence)this.message) ? this.message : "null");
        }
    }

    @KeepClassMembers
    public static class n {
        public String host;
        public String path;
        public String query;
    }

    @KeepClassMembers
    public static class c {
        public a[] userMetas;
        public q userModel;
        public n socket;

        @KeepClassMembers
        public static class a {
            public int label = -1;
            public String userToken;
            public String role;
        }
    }

    @KeepClassMembers
    public static class b
    extends l {
        private final List<o> targetUsers;
        public boolean newSocket = true;

        public b(String string, String string2, String string3) {
            super(string, string2);
            this.targetUsers = TextUtils.isEmpty((CharSequence)string3) ? null : Collections.singletonList(new o(string3));
        }
    }

    @KeepClassMembers
    public static class l {
        private final String chatId;
        private final String userToken;

        public l(String string, String string2) {
            this.chatId = string;
            this.userToken = string2;
        }
    }

    @KeepClassMembers
    public static class h {
        public String chatWriteMode;
        public String channelCode;
        public int guestCount;
        public String id;
        public int inputInterval;
        public int memberCount;
        public List<a> sticker;
        public List<Map> aggregated;
        public String arcMsgURL;

        public SimpleArrayMap<String, String> getStickerMap() {
            SimpleArrayMap simpleArrayMap = new SimpleArrayMap();
            if (this.sticker != null) {
                for (a a2 : this.sticker) {
                    for (Map.Entry<String, String> entry : a2.stickers.entrySet()) {
                        simpleArrayMap.put((Object)entry.getKey(), (Object)entry.getValue());
                    }
                }
            }
            return simpleArrayMap;
        }

        public List<Sticker> getStickerSuite() {
            ArrayList<Sticker> arrayList = new ArrayList<Sticker>();
            if (this.sticker != null) {
                for (a a2 : this.sticker) {
                    Sticker sticker = new Sticker();
                    sticker.mMainImage = a2.mainImage;
                    sticker.mName = a2.name;
                    sticker.mStickers = a2.stickers;
                    arrayList.add(sticker);
                }
            }
            return arrayList;
        }

        public ChatroomInfo toChatroomInfo() {
            return new ChatroomInfo(ChatMode.a(this.chatWriteMode), this.channelCode, this.guestCount, this.memberCount, this.inputInterval, this.getStickerSuite());
        }

        @KeepClassMembers
        public static class a {
            public String mainImage;
            public String name;
            public Map<String, String> stickers;
        }
    }
}

